# Code for Effectively Modeling Time Series with Simple Discrete State Spaces   

This folder contains code for our ICLR 2023 submission.  

## Requirements

To install requirements, we recommend setting up a virtual environment with conda:

```setup
conda env create -f environment.yml  
conda activate cnc
``` 
Alternatively, we provide a list of known dependencies for installation.


List of (known) dependencies:  
* python 3.10  
* einops 0.4.1  
* gluonts 0.8.1  
* matplotlib 3.5.1  
* numpy 1.21.5  
* omegaconf 2.1.1
* opt_einsum 3.3.0  
* pandas 1.4.2  
* pillow 8.0.1  
* pytorch 1.11.0  
* rich 10.16.2  
* scikit-learn 1.0.2  
* scipy 1.8.0 
* statsmodels 0.13.2  
* tqdm 4.64.0  
* wandb 0.12.18


## Datasets and code 

We provide all dataloaders and source CSVs for the informers datasets in `./dataloaders/`


## Sample scripts


### ETTh1 

```
python main.py --dataset etth1 --lag 336 --horizon 720 --network_config spacetime_control_companion_wide3 --task_norm mean --max_epochs 50 --lr 0.01 --weight_decay 0.0001 --batch_size 50 --model_dropout 0.25 --optimizer adamw --scheduler timm_cosine --seed 0 --no_wandb --bash --features S
```


### ETTh2 

```
python main.py --dataset etth2 --lag 336 --horizon 720 --network_config spacetime_control_companion_wide3 --task_norm mean --max_epochs 50 --lr 0.01 --weight_decay 0.0001 --batch_size 50 --model_dropout 0.25 --optimizer adamw --scheduler timm_cosine --seed 0 --no_wandb --bash --features S
```

### ETTm1 

```
python main.py --dataset ettm1 --lag 336 --horizon 720 --network_config spacetime_control_companion_wide3 --task_norm mean --max_epochs 50 --lr 0.01 --weight_decay 0.0001 --batch_size 50 --model_dropout 0.25 --optimizer adamw --scheduler timm_cosine --seed 0 --no_wandb --bash --features S
```

### ETTm2 

```
python main.py --dataset ettm2 --lag 336 --horizon 720 --network_config spacetime_control_companion_wide3 --task_norm mean --max_epochs 50 --lr 0.01 --weight_decay 0.0001 --batch_size 50 --model_dropout 0.25 --optimizer adamw --scheduler timm_cosine --seed 0 --no_wandb --bash --features S
```

