import importlib


def initialize_data_functions(args):
    """
    Retrieve dataloaders and visualization function. 
    
    Example:
        load_data, visualize_data = initialize_data_functions(args)
        dataloaders, dataset = load_data(config.dataset, config.loader)
    """
    dataset_module = importlib.import_module(f'dataloaders.{args.dataset}')
    load_data = getattr(dataset_module, 'load_data')
    visualize_data = getattr(dataset_module, 'visualize_data')
    return load_data, visualize_data