# Continual learning using hash-routed convolutional neural networks

## Description

This software package contains the code to run and evaluate HRN.

## 1- System requirements

This software package was developed and tested using the following
 configuration:
 
 Hardware: At least 8 GB of RAM and preferably a NVIDIA P100 GPU (tested
  using CUDA 10.1 and libcudnn7)
 
 OS: Tested on Ubuntu 18.04 LTS and 20.04 LTS
 
 Python: Tested using Python 3.7 and python 3.8 (Anaconda3 2020.02 and Anaconda
  2020.07)
 
## 2- Installation

The *requirements.txt* file contains *pip* dependencies needed to run the
 software.
 
 ```bash
 pip install -r requirements.txt
 ```

The software can also be installed as python package:

```bash
pip install -e hrn/
```

## 3- Training

If the software was not installed as python package, add the path to the
 *hrn* folder to PYTHONPATH.

Go into the software package root folder

```bash
cd hrn
```

To train a HRN, run:

```bash
python Scripts/training/training_s.py Scripts/conf/pmnist.yaml cpu
```

If your machine has one or more GPUs, you can run:

```bash
python Scripts/training/training_s.py Scripts/conf/pmnist.yaml cuda -d 0
```

(this selects GPU 0 for training)

The *Scripts/conf* folder contains YAML configuration files that can be used
 to describe the HRN and the scenarios to run.

## 4- Data analysis

This software uses [MLflow](https://mlflow.org/)  to log training metrics
. Running a training script will create the *hrn/mlruns* folder containing
 the MLflow database.
 Tensorboard can also be used to view realtime metrics. Logs can be found in
 the  created *../data* folder.

## 5- Paper experiments
Configuration files used for the experiments presented in the paper can be
 found in the *Scripts/conf/paper* folder. 
 The *Scripts/conf/paper/ablation* folder contains the configuration files
  used for the ablation study (see the description inside each file for more
   detail).
Scripts for Elastic Weight Consolidation (**EWC**), Encoder based Lifelong
 Learning  (**ELL**) and Vanilla Convolution (**VC**) are available in the
  *Scripts/benchmarks* folder. For example, to run a vanilla convolution on a
   pairwise-MNIST configuration:
```bash
python Scripts/training/benchmarks/training_vc.py Scripts/conf/paper/vc/pmnist_vc.yaml cuda -d 0
```
