import pydub
from pydub import AudioSegment
import math

import os

def divide_(files, source, target):
    os.makedirs(target,exist_ok=True)
    for each in files:
        # Load the M4A file
        audio = AudioSegment.from_file(source+each, format="m4a")

        # Get the length of the audio in milliseconds
        audio_length = len(audio)

        # Calculate the number of segments
        segment_duration = 10000  # 10 seconds in milliseconds
        num_segments = math.ceil(audio_length / segment_duration)

        # Divide the audio into 10-second segments
        for i in range(num_segments):
            start_time = i * segment_duration
            end_time = min((i + 1) * segment_duration, audio_length)
            segment = audio[start_time:end_time]
            
            # Export each segment as a separate WAV file
            name = each.split('.')[0]
            segment.export(target + f"{name}_output_segment_{i+1}.wav", format="wav")


divide_(['CU13.m4a', 'CU15.m4a'],
    '/proj/vondrick4/chengzhi/2024/classifydata/custom_noise/', 
        '/proj/vondrick4/chengzhi/2024/classifydata/piece_custom_noise2/')

