import os
import shutil
import librosa
from mutagen.flac import FLAC
from mutagen.mp3 import MP3
from pydub import AudioSegment


def is_valid_wav(file_path):
    try:
        # Try to load the file using librosa
        librosa.load(file_path, sr=None)
        file_size = os.path.getsize(file_path)
        if file_size < 5000:
            try:
                audio = AudioSegment.from_file(file_path)
                if len(audio) == 0:
                    return False
            except:
                return False
            
            try:
                if filename.endswith(".flac"):
                    audio_file = FLAC(file_path)
                elif filename.endswith(".mp3"):
                    audio_file = MP3(file_path)
                
                if len(audio_file) == 0:
                    print(f"File {filename} has no metadata")
                    return False
            except:
                print(f"File {filename} is corrupted or has no metadata")
                return False


        return True
    except Exception as e:
        # If an exception occurs, the file is not valid
        return False

def move_valid_wav_files(source_folder, destination_folder):
    # Ensure the destination folder exists
    os.makedirs(destination_folder, exist_ok=True)

    # Walk through the source folder
    for root, dirs, files in os.walk(source_folder):
        # print('files', files)
        for file in files:
            if file.endswith('.wav') or file.endswith('.flac'):
                source_file_path = os.path.join(root, file)
                
                if is_valid_wav(source_file_path):
                    # Determine the relative path of the file
                    relative_path = os.path.relpath(source_file_path, source_folder)
                    
                    # Create the destination file path
                    destination_file_path = os.path.join(destination_folder, relative_path)
                    
                    # Ensure the destination subfolder exists
                    os.makedirs(os.path.dirname(destination_file_path), exist_ok=True)
                    
                    # Move the file
                    shutil.move(source_file_path, destination_file_path)
                    print(f'Moved: {source_file_path} -> {destination_file_path}')
                else:
                    print(f'Invalid: {source_file_path}')

# Example usage
# source_folder = '/proj/vondrick4/chengzhi/2024/data/elevenlab_apiGen_bona_fide_audio_paid_chuck_1024/'
source_folder = '/proj/vondrick4/chengzhi/2024/classifydata/LibriSpeech/valid_train-clean-100-elevenlab_apiGen_paid_chuck_1024'
# destination_folder = '/proj/vondrick4/chengzhi/2024/classifydata/eleven_paid_gen_ours'
destination_folder = '/proj/vondrick4/chengzhi/2024/classifydata/LibriSpeech/validonly_train-clean-100-elevenlab_apiGen_paid_chuck_1024'
move_valid_wav_files(source_folder, destination_folder)
