import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--epochs", type=int, default=10)
parser.add_argument("--bs", type=int, default=32)
parser.add_argument("--lr", type=float, default=0.00001)
# saved dir
parser.add_argument("--ckp_dir", type=str, default="checkpoints3")
# parser.add_argument("--root", type=str, default="/local/rcs/zz3093/data/deepfake_VCTK/")
# mixup
parser.add_argument('--mixup', dest='mixup', action='store_true',
                    help='add mixup')
parser.add_argument("--mixup_alpha", type=float, default=0.1)

# noise augmentation
parser.add_argument('--noise', dest='noise', action='store_true',
                    help='use noise when train')

# nosie snr
parser.add_argument("--snr", type=float, default=0.5)

# noise augmentation ratio
parser.add_argument("--noise_ratio", type=float, default=0.5)

# fake data ratio
parser.add_argument("--fake_ratio", type=float, default=1)

# max frames
parser.add_argument("--max_frames", type=int, default=600)

# step size
parser.add_argument("--step_size", type=int, default=300)

# phone augmentation
parser.add_argument('--phone', dest='phone', action='store_true',
                    help='use phone simulator')

# phone augmentation ratio
parser.add_argument("--phone_ratio", type=float, default=0.5)

# phone call low pass max band
parser.add_argument("--phone_low_pass_max", type=int, default=80)

# phone call low pass min band
parser.add_argument("--phone_low_pass_min", type=int, default=20)

"""
attack hyperparameters
"""
parser.add_argument('--attack', default='none', type=str, choices=['pgd', 'fgsm', 'none', 'discrete', 'spectrum'])
parser.add_argument('--epsilon', default=0.0005, type=float)
parser.add_argument('--attack_iters', default=2, type=int)
parser.add_argument('--restarts', default=1, type=int)
parser.add_argument('--pgd-alpha', default=0.0001, type=float)
parser.add_argument('--fgsm-alpha', default=1.25, type=float)
parser.add_argument('--norm', default='l_inf', type=str, choices=['l_inf', 'l_2'])
parser.add_argument('--early-stop', action='store_true')

# robust loss gamma
parser.add_argument("--gamma", type=float, default=0.1)

# attack_start_epoch
parser.add_argument("--attack_start_epoch", type=int, default=0)

# lower limit and upper limit
parser.add_argument("--lower_limit", type=float, default=-1.0)
parser.add_argument("--upper_limit", type=float, default=1.0)

# lr scheduler
# warmup_epochs
parser.add_argument("--warmup_epochs", type=int, default=1)

# warmup_lr
parser.add_argument("--warmup_lr", type=float, default=0.000001)
# min_lr
parser.add_argument("--min_lr", type=float, default=0.0000001)

# resume
parser.add_argument('--resume', dest='resume', action='store_true',
                    help='resume from checkpoints')

"""
attack augmentation
"""
# time strecth
parser.add_argument('--time_stretch', dest='time_stretch', action='store_true',
                    help='use time stretch augmentation')

parser.add_argument('--time_stretch_ratio', type=float, default=0.25)

# time stretch min
parser.add_argument("--time_stretch_min", type=float, default=0.67)

# time stretch max
parser.add_argument("--time_stretch_max", type=float, default=1.5)

# discrete_attack_ratio
parser.add_argument("--discrete_attack_ratio", type=float, default=0.5)

# pitch shift
parser.add_argument('--pitch_shift', dest='pitch_shift', action='store_true',
                    help='use pitch shift augmentation')

parser.add_argument('--pitch_shift_ratio', type=float, default=0.25)

# pitch shift min
parser.add_argument("--pitch_shift_min", type=float, default=-2)

# pitch shift max
parser.add_argument("--pitch_shift_max", type=float, default=2)

# downsample
parser.add_argument('--downsample', dest='downsample', action='store_true',
                    help='use downsample augmentation')

parser.add_argument('--downsample_ratio', type=float, default=0.5)

# downsample min
parser.add_argument("--downsample_min", type=int, default=8000)

"""
input audio sample rate
"""
parser.add_argument("--audio_sample_rate", type=int, default=16000)

"""
low pass filter to remove high frequency
"""
parser.add_argument("--low_pass_filter", dest='low_pass_filter', action='store_true',
                    help='use low pass filter to remove high frequency')

"""
random augmentations num
"""
parser.add_argument("--aug_num", type=int, default=1)

"""
original_aug_prob
"""
parser.add_argument("--aug_prob", type=float, default=1.0)

"""
num of experts
"""
parser.add_argument("--num_experts", type=int, default=4)

# name: expert_name
parser.add_argument("--expert_name", type=str, default="dense_moes", choices=["dense_moes", "sparse_moes"])

"""
spectrum attack parameters
"""
# target frequency
parser.add_argument("--spectrum_target_freq", type=int, default=4000)

# spectrum attack epsilon
parser.add_argument("--spectrum_epsilon", type=float, default=0.005)

# spectrum attack alpha
parser.add_argument("--spectrum_alpha", type=float, default=0.002)

# spectrum attack restarts
parser.add_argument("--spectrum_restarts", type=int, default=1)

# spectrum attack iters
parser.add_argument("--spectrum_attack_iters", type=int, default=2)

args = parser.parse_args()

print(args)
