import os
import shutil
import random

def move_half_files(source_folder, destination_folder):
    # Ensure the destination folder exists
    os.makedirs(destination_folder, exist_ok=True)

    # Get a list of all files in the source folder
    files = [f for f in os.listdir(source_folder) if os.path.isfile(os.path.join(source_folder, f))]
    
    # Shuffle the list to randomly select files
    random.shuffle(files)
    
    # Determine the number of files to move (half of the total)
    num_files_to_move = len(files) // 2
    
    # Move the selected files to the destination folder
    for file in files[:num_files_to_move]:
        src = os.path.join(source_folder, file)
        dst = os.path.join(destination_folder, file)
        shutil.move(src, dst)

# Example usage
source_folder = '/proj/vondrick4/chengzhi/2024/classifydata/elevenlabs'
destination_folder = '/proj/vondrick4/chengzhi/2024/classifydata/elevenlabs_test'
move_half_files(source_folder, destination_folder)
