from pathlib import Path
import pandas as pd

TAGS = ("EVAL-accuracy", "EVAL-f1_score", "EVAL-precision", "EVAL-recall")

OUR_ARCH_NAME = "FPTT (Ours)"

RUNS_BY_ARCH = {
    OUR_ARCH_NAME: (
        "2024-09-26T12:53:01.882244",
        "2024-09-26T16:29:07.538218",
        "2024-09-26T20:06:40.770120",
        "2024-09-26T23:41:10.458633",
        "2024-09-27T03:14:28.295558",
    ),
    "STEVE": (
        "2024-09-27T09:36:00.126272",
        "2024-09-27T13:13:52.700686",
        "2024-09-27T16:51:10.034724",
        "2024-09-27T20:27:44.197885",
        "2024-09-28T00:04:24.760457",
    ),
    "Decoder only": (
        "2024-09-23T15:48:36.415444",
        "2024-09-25T09:32:15.446818",
        "2024-09-25T18:40:35.093088",
        "2024-09-26T03:20:39.343215",
        "2024-09-26T12:04:42.006394",
    ),
    "FPTT-pre": (
        "2024-09-26T13:41:09.839244",
        "2024-09-26T17:16:22.075014",
        "2024-09-26T20:52:32.358179",
        "2024-09-27T00:26:01.648201",
        "2024-09-27T03:58:15.965840",
    ),
}

def read_run(run, tag):
    return pd.read_csv(
        Path("../logs") / Path(run) / Path(tag).with_suffix(".csv")
    )

def calculate_line(tag, arch):
    dataframes = []
    for run in RUNS_BY_ARCH[arch]:
        dataframes.append(read_run(run, tag))
    data = pd.concat(dataframes).groupby("step", as_index=False)

    mean = data.mean(numeric_only=True)
    sem = data.sem(numeric_only=True)

    return mean, sem
