"""
Does the IDENTICAL SAME THING as eval_3transf,
but with a different conf that will change the structure
to be like SAVi/STEVE, where the loss is collected b/w correct and predict.
"""

import torch
import hydra
import eval_3transf_worldmodeling as actual_code

def hydraconf_autohandle_torch_device(f):
    def wrapper(conf):
        if conf.device == "CUDA_IF_AVAILABLE":
            conf.device = "cuda:0" if torch.cuda.is_available() else "cpu"
        conf.device_type = 'cuda' if 'cuda' in conf.device else 'cpu'
        f(conf)
    return wrapper

@hydra.main(config_path="config", config_name="evalwm-SLOTS-PRE-phyre")
@hydraconf_autohandle_torch_device
def hydra_main(conf):
    actual_code.code_main(conf)



if __name__ == "__main__":
    hydra_main()
