## Core Code for VideoAnchor Implementation

Please follow the steps below to set up the environment and integrate VideoAnchor for VSI-Bench evaluation:

1. **Environment Setup**  
   Refer to the [thinking-in-space repository](https://github.com/vision-x-nyu/thinking-in-space) and [SSC-Py-CUDA](https://github.com/XHMY/SSC-Py-CUDA) for environment installation instructions, which we gratefully acknowledge. 

2. **Install SSC**  
   ```bash
   cd SSC-Py-CUDA
   pip install -e .
   cd ..
   ```

3. **Integrate Model Wrappers**  
   Move the following files into the lmms_eval/models directory:
- internvl2/internvl2.py
- llava_video/llava_vid.py
- qwen2.5vl/qwen2_5_vl.py

4. **Update Dependencies**  
   Move other files to the right places in *transformers* or the model huggingface folder.

5. **Evaluation**  
   Refer to the [thinking-in-space repository](https://github.com/vision-x-nyu/thinking-in-space) for the evaluation.