#!/bin/bash

if [ "$#" -ne 1 ]; then
    echo "Usage: $0 <path_to_config>"
    exit 1
fi

INFERENCE_SETTINGS_PATH=$1

NUM_GPUS=$(python -c "import torch; print(torch.cuda.device_count())")
accelerate launch --module --num_processes=$NUM_GPUS src run_offline_metrics --inference_settings_path $INFERENCE_SETTINGS_PATH
ls inference_output/
echo "Done!"
