from pathlib import Path
import typer

from src import pipelines
from src.cli.app import app
from src.settings.pipelines.inference.chat import (
    ChatInferenceExperimentSettings,
)
from src.settings.pipelines.inference.metrics import MetricsSettings
from src.settings.pipelines.inference.offline_metrics import PairOfflineMetricsSettings


@app.command(name='inference_chat', help='Infer model on chat dataset')
def infer_chat_entrypoint(
    inference_settings_path: Path = typer.Option(
        ..., '--inference_settings_path', exists=True, help='Path to inference config file'
    )
) -> None:
    inference_settings = ChatInferenceExperimentSettings.parse_file(inference_settings_path)
    pipelines.ChatInferenceStrategy().run(inference_settings)


@app.command(name="run_metrics", help="Run metrics evaluation")
def infer_metrics(
    inference_settings_path: Path = typer.Option(
        ..., '--inference_settings_path', exists=True, help='Path to inference config file'
    )
):
    inference_settings = MetricsSettings.parse_file(inference_settings_path)
    pipelines.MetricsInferenceStrategy().run(inference_settings)


@app.command(name="run_offline_metrics", help="Run offline metrics evaluation")
def infer_offline_metrics(
    inference_settings_path: Path = typer.Option(
        ..., '--inference_settings_path', exists=True, help='Path to inference config file'
    )
):
    inference_settings = PairOfflineMetricsSettings.parse_file(inference_settings_path)
    pipelines.OfflineMetricsInferenceStrategy().run(inference_settings)
