from pathlib import Path
import typer


from src import pipelines
from src.cli.app import app
from src.settings import pipelines as pipeline_settings


@app.command(name='train_sft', help='Run PEFT pipeline')
def train_sft_entrypoint(
    experiment_settings_path: Path = typer.Option(
        ...,
        '--experiment_settings_path',
        exists=True,
        help='Path to experiment config file',
    )
) -> None:
    experiment_settings = pipeline_settings.SftTrainExperimentSettings.parse_file(experiment_settings_path)
    pipelines.TrainSFTStrategy().run(experiment_settings)


@app.command(name='train_dpo', help='Run DPO pipeline')
def train_dpo_entrypoint(
    experiment_settings_path: Path = typer.Option(
        ..., '--experiment_settings_path', exists=True, help='Path to experiment config file'
    )
) -> None:
    experiment_settings = pipeline_settings.DPOTrainExperimentSettings.parse_file(experiment_settings_path)
    pipelines.TrainDPOStrategy().run(experiment_settings)
