from typing import Any

from src.dataset.base.models import DatasetRecord
from src.dataset.chat.models import ChatMessage


class PairPreferenceRecord(DatasetRecord):
    """
    answer_w - preferred answer
    answer_l - other answer
    """

    context: list[ChatMessage]
    answer_w: ChatMessage
    answer_l: ChatMessage
    precomputed_margin: float | None = None
    meta: dict[str, Any] | None = None
