import abc

from src.common.registry import Registrable
from src.metrics.registry import MetricSettings
from src.settings.metric import MetricResults


class Metric(abc.ABC, Registrable):
    def __init__(self, settings: MetricSettings) -> None:
        self._settings: MetricSettings = settings

    @abc.abstractmethod
    def compute(self, **kwargs) -> list[MetricResults]: ...
