from src.settings.base import ExtraFieldsNotAllowedBaseModel
from src.settings.datasets.base import MultiDatasetSettings
from src.settings.datasets.chat import ChatMultiDatasetSettings
from src.settings.datasets.pair_preference import PairPreferenceMultiDatasetSettings
from src.settings.generators.chat import CustomChatGenerationSettings
from src.settings.metric import MetricSettings
from src.settings.tf.generation import GeneratorTransformersSettings


class CherryPickSettings(ExtraFieldsNotAllowedBaseModel):
    dataset_settings: MultiDatasetSettings
    metric_settings: list[MetricSettings]


class RMCherryPickSettings(CherryPickSettings):
    dataset_settings: PairPreferenceMultiDatasetSettings


class GenerationSettings(CherryPickSettings):
    generator_transformers_settings: GeneratorTransformersSettings
    custom_generation_settings: CustomChatGenerationSettings


class ChatCherryPickSettings(GenerationSettings):
    dataset_settings: ChatMultiDatasetSettings
