from typing import Literal

from src.settings.datasets.base import BaseDatasetSettings, DatasetType, MultiDatasetSettings
from src.settings.datasets.chat import ChatDatasetSettings


class PairPreferenceDatasetSettings(BaseDatasetSettings):
    dataset_type: Literal[DatasetType.PAIR_PREFERENCES] = DatasetType.PAIR_PREFERENCES
    chat_settings: ChatDatasetSettings
    add_labels: bool = True


class PairPreferenceMultiDatasetSettings(PairPreferenceDatasetSettings, MultiDatasetSettings): ...
