from pathlib import Path

from src.settings.base import ExtraFieldsNotAllowedBaseModel
from src.settings.model import PreTrainedModelSettings
from src.settings.tf.tokenizer import TokenizerSettings


class MergeAdaptersToBaseModelSettings(ExtraFieldsNotAllowedBaseModel):
    model_settings: PreTrainedModelSettings
    tokenizer_settings: TokenizerSettings

    adapter_path: Path
    save_path: Path

    max_shard_size: str = '400MB'
