# Controlled Visual Hallucination via Thalamus-Driven Decoupling Network for Domain Adaptation of Black-Box Predictors

This is the implementation of ”Controlled Visual Hallucination via Thalamus-Driven Decoupling Network for Domain Adaptation of Black-Box Predictors“

## Appendix.

The complete appendix is presented in Appendix.pdf

## Main code.

**Step 1. Training black-box source domain**

```shell
# office31
sh office31_src.sh

# officehome
sh officehome_src.sh
```

**Step 2. Adapting to target domain using CVH-TDM**

```shell
# office31
sh office31_train.sh

# officehome
sh officehome_train.sh
```

## Visual Experimental Code.
```
python t-sne.py
python cam.py --image-path ./input_img.jpg --output-dir ./ --pt CVH_TDN.pt
python confusion_matrix.py
```