import os
import pandas as pd


def func(sized_df, method):	
    metric_columns = ['sep_min', 'max_avg', 'max_diam', 'sep_avg', 'cs_ratio_AV', 'cs_ratio_DM'] 

    output = {key:0 for key in metric_columns}

    greater_is_better = {
        'sep_min': True,
        'max_avg': False,
        'max_diam': False,
        'sep_avg': True,
        'cs_ratio_AV': False,
        'cs_ratio_DM': False
    }
    for k in sized_df['k'].unique().tolist():
        k_df = sized_df[sized_df['k'] == k]
        for metric in metric_columns:
            metric_values = k_df[metric].tolist()
            if greater_is_better[metric]:
                best = max(metric_values)
            else:
                best = min(metric_values)
            if method in k_df[k_df[metric] == best]['method'].tolist():
                output[metric] += 1
    return pd.DataFrame(output, index=[0])

def summarize(df):
    sizes = df['k_size'].unique().tolist()
    summary = pd.DataFrame()

    df = df.loc[df['method'] != 'ward']

    for size in sizes:
        for method in df['method'].unique().tolist():
            sized_df = df[df['k_size'] == size]
            line = func(sized_df, method)
            line['method'] = method
            line['k_size'] = size
            summary = pd.concat([summary, line], ignore_index=True)
    summary = summary[['k_size', 'method', 'sep_min', 'max_avg', 'max_diam', 'sep_avg', 'cs_ratio_AV', 'cs_ratio_DM']]
    return summary

def main():
    all_summary = pd.DataFrame()
    folder_path = r'results_linf'
    output_file = r'extra_results\all_summary_linf.csv'

    for file in os.listdir(folder_path):
        if file.endswith('.csv'):
            file_name = file.split('_')[0]

            df = pd.read_csv(folder_path+'\\'+file, sep='|')

            summary = summarize(df)

            summary['data_set'] = file_name
            summary = summary[['data_set', 'k_size', 'method', 'sep_min', 'max_avg', 'max_diam', 'sep_avg', 'cs_ratio_AV', 'cs_ratio_DM']]

            all_summary = pd.concat([all_summary, summary], ignore_index=True)
    all_summary.to_csv(output_file, sep='|', index=False)
    return

if __name__ == '__main__':
    main()