import json
from tqdm import tqdm
import random
from datasets import load_dataset

from swift.llm import (
        get_model_tokenizer, get_template, inference, ModelType,
        get_default_template_type, inference_stream
    )
from swift.utils import seed_everything
import logging
from .utils import *

def MathVista(args,val_data, model, template ):
    seed_everything(42)
    args.local_image_path = '/Uncertainty_MLLMs/MathVista/test/'
    chiocels0=['A','B','C','D','E','F','G','H']
    for index, item in enumerate(val_data, start=1):
        item['index'] = int(item['pid'])
        letter2ans={}
        ans2letter={}
        for id_ch,choice in enumerate(item['choices']):
            letter2ans[chiocels0[id_ch]]=choice
            ans2letter[choice]=chiocels0[id_ch]
        item['answer'] = ans2letter[item["answer"]]
        item['choices'] = letter2ans
        pid = str(item['pid']) + '.jpg'
        item['image']='test/'+pid
        item['category']='math_'+item["metadata"]['task']
    answer_all=[]
    for idx, item in enumerate(tqdm(val_data, desc="All data")):
        index = item["index"]
        question = item["question"]
        choices=item['choices']
        answer = item["answer"]  
        category=item['category']
        image = args.local_image_path + str(index) + '.jpg'
        prompt= construct_query_base_MC(question,choices)
        if args.api_model:
            response_temp = get_all_model_api_result(args, prompt, image)
        elif args.model_type == 'phi3-vision-128k-instruct':
            prompt = f'<img>{image}</img>{prompt}'
            response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
        else :
            response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
        
        response = extract_option(response_temp, question)
        
        answer_data_json = {
            'index': index,
            'question': question,
            'answer' : answer,
            'choices':choices,
            'response': response,
            'response_temp': response_temp,
            'prompt': prompt,
            'category':category
        }

        answer_all.append(answer_data_json)

    save_path = cacluate_current_time_save_path('all', args)
    json.dump(answer_all, open(save_path, 'w',encoding='utf-8'),
                      indent=2, ensure_ascii=False)
    consistent_ratio, inconsistent_ratio = calculate_consistency_MC(answer_all,'All data-')


    filtered_data_false_true = []
    filtered_data_true_false = []
    for item in answer_all:
        response = item['response']
        true_answer  = item['answer']

        if  true_answer == response :
            filtered_data_true_false.append(item)
        elif response == -2 :
            pass
        else:
            filtered_data_false_true.append(item)

    save_path= cacluate_current_time_save_path('all_false',args)
    json.dump(filtered_data_false_true, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)

    save_path= cacluate_current_time_save_path('all_true',args)
    json.dump(filtered_data_true_false, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)
    

    logging.info(f"False Count:{len(filtered_data_false_true)}")
    for i in range(1):
        answer_new_F_T = []
        for qid, item in enumerate(tqdm(filtered_data_false_true, desc="False->True")):
            index = item["index"]
            question = item["question"]
            choices=item['choices']
            answer = item["answer"] 
            category=item['category'] 
            image = args.local_image_path + str(index) + '.jpg'
            prompt= construct_query_MC(question,choices,answer)
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{image}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
            
            response = extract_option(response_temp, question)
            
            answer_data_json = {
                'index': index,
                'question': question,
                'answer' : answer,
                'choices':choices,
                'response': response,
                'response_temp': response_temp,
                'prompt': prompt,
                'category':category
            }

            answer_new_F_T.append(answer_data_json)

        save_path= cacluate_current_time_save_path('false_true',args)
        json.dump(answer_new_F_T, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)

        consistent_ratio_false_true, inconsistent_ratio_false_true = calculate_consistency_MC(answer_new_F_T,'False->True-')

    logging.info(f"False Count:{len(filtered_data_false_true)}")
    for i in range(1):
        answer_new_F_F=[]
        for qid, item in enumerate(tqdm(filtered_data_false_true, desc="False->False")):
            index = item["index"]
            question = item["question"]
            choices=item['choices']
            answer = item["answer"]  
            category=item['category']
            image = args.local_image_path + str(index) + '.jpg'
            prompt= construct_query_MC(question,choices,select_random_choice(answer,len(choices)))
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{image}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
            
            response = extract_option(response_temp, question)
            
            answer_data_json = {
                'index': index,
                'question': question,
                'answer' : answer,
                'choices':choices,
                'response': response,
                'response_temp': response_temp,
                'prompt': prompt,
                'category':category
            }

            answer_new_F_F.append(answer_data_json)

        save_path= cacluate_current_time_save_path('false_false',args)
        json.dump(answer_new_F_F, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)
        consistent_ratio_false_true, inconsistent_ratio_false_true = calculate_consistency_MC(answer_new_F_F,'False->False-')


    logging.info(f"True Count:{len(filtered_data_true_false)}")
    for i in range(1):
        answer_new_T_F = []
        for qid, item in enumerate(tqdm(filtered_data_true_false, desc="True->False")):
            index = item["index"]
            question = item["question"]
            choices=item['choices']
            answer = item["answer"]
            category=item['category']  
            image = args.local_image_path + str(index) + '.jpg'
            prompt= construct_query_MC(question,choices,select_random_choice(answer,len(choices)))
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{image}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
            
            response = extract_option(response_temp, question)
            
            answer_data_json = {
                'index': index,
                'question': question,
                'answer' : answer,
                'choices':choices,
                'response': response,
                'response_temp': response_temp,
                'prompt': prompt,
                'category':category
            }

            answer_new_T_F.append(answer_data_json)

        save_path= cacluate_current_time_save_path('true_false',args)
        json.dump(answer_new_T_F, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)
        consistent_ratio_true_false, inconsistent_ratio_true_false = calculate_consistency_MC(answer_new_T_F, 'True->False')


    logging.info(f"True Count:{len(filtered_data_true_false)}")
    for i in range(1):
        answer_new_T_T=[]
        for qid, item in enumerate(tqdm(filtered_data_true_false, desc="True->True")):
            index = item["index"]
            question = item["question"]
            choices=item['choices']
            answer = item["answer"] 
            category=item['category'] 
            image = args.local_image_path + str(index) + '.jpg'
            prompt= construct_query_MC(question,choices,answer)
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{image}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
            
            response = extract_option(response_temp, question)
            
            answer_data_json = {
                'index': index,
                'question': question,
                'answer' : answer,
                'choices':choices,
                'response': response,
                'response_temp': response_temp,
                'prompt': prompt,
                'category':category
            }

            answer_new_T_T.append(answer_data_json)

        save_path= cacluate_current_time_save_path('true_true',args)
        json.dump(answer_new_T_T, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)
        consistent_ratio_true_false, inconsistent_ratio_true_false = calculate_consistency_MC(answer_new_T_T, 'True->True')
