import json
from tqdm import tqdm
from swift.llm import (
        get_model_tokenizer, get_template, inference, ModelType,
        get_default_template_type, inference_stream
    )
from swift.utils import seed_everything
import logging
from .utils import *



def MMstar(args,val_data, model, template ):
    seed_everything(42)
    args.local_image_path = '/MLLMs/MMStar'
    answer_all=[]
    for idx, item in enumerate(tqdm(val_data, desc="Processing items")):
        index = item["index"]
        question = item["question"]
        image = item["image"]
        answer = item["answer"]
        category = item["category"]
        l2_category = item["l2_category"]
        meta_info = item["meta_info"]
        image_path = meta_info['image_path']

        temp_image_path = os.path.join(args.local_image_path, image_path)
        
        prompt= SYSTEM_MSG_MC + question 

        if args.api_model:
            response_temp = get_all_model_api_result(args, prompt, image)
        elif args.model_type == 'phi3-vision-128k-instruct':
            prompt = f'<img>{temp_image_path}</img>{prompt}'
            response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
        else :
            response_temp, _ = inference(model, template, prompt, images=temp_image_path,temperature=args.tempeature)

        response = extract_option(response_temp, question)
        
        answer_data_json = {
            'index': index,
            'image' : temp_image_path,
            'question': question,
            'answer' : answer,
            'response': response,
            'response_temp': response_temp,
            'category' : category ,
            'l2_category': l2_category,
            'meta_info': meta_info ,
            'prompt':prompt
        }

        answer_all.append(answer_data_json)

    save_path = cacluate_current_time_save_path('all', args)
    json.dump(answer_all, open(save_path, 'w',encoding='utf-8'),
                      indent=2, ensure_ascii=False)
    consistent_ratio, inconsistent_ratio = calculate_consistency_MC(answer_all,'All data-')
    

    filtered_data_false_true = []
    filtered_data_true_false = []
    for item in answer_all:
        response = item['response']
        true_answer  = item['answer']

        if  response == true_answer:
            filtered_data_true_false.append(item)
        elif response == -2 :
            pass
        else:
            filtered_data_false_true.append(item)

    logging.info(len(filtered_data_false_true))
    save_path= cacluate_current_time_save_path('all_false',args)
    json.dump(filtered_data_false_true, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)

    logging.info(len(filtered_data_true_false))
    save_path= cacluate_current_time_save_path('all_true',args)
    json.dump(filtered_data_true_false, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)
    

    for i in range(1):
        answer_new_F_T = []
        for qid, item in enumerate(tqdm(filtered_data_false_true, desc="False->True")):
            index = item["index"]
            question = item["question"]
            image = item["image"]
            answer = item["answer"]
            category = item["category"]
            l2_category = item["l2_category"]
            meta_info = item["meta_info"]
            image_path = meta_info['image_path']

            temp_image_path = os.path.join(args.local_image_path, image_path)
            prompt=   construct_query_MMstar(question,answer)
            
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{temp_image_path}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=temp_image_path,temperature=args.tempeature)

            response = extract_option(response_temp, question)
            
            answer_data_json = {
                'index': index,
                'image' : temp_image_path,
                'question': question,
                'answer' : answer,
                'response': response,
                'response_temp': response_temp,
                'category' : category ,
                'l2_category': l2_category,
                'meta_info': meta_info ,
                'prompt':prompt
            }

            answer_new_F_T.append(answer_data_json)

        save_path= cacluate_current_time_save_path('false_true',args)
        json.dump(answer_new_F_T, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)

        consistent_ratio_false_true, inconsistent_ratio_false_true = calculate_consistency_MC(answer_new_F_T,'False->True-')


    for i in range(1):
        answer_new_F_F = []
        for qid, item in enumerate(tqdm(filtered_data_false_true, desc="False->False")):
            index = item["index"]
            question = item["question"]
            image = item["image"]
            answer = item["answer"]
            category = item["category"]
            l2_category = item["l2_category"]
            meta_info = item["meta_info"]
            image_path = meta_info['image_path']

            temp_image_path = os.path.join(args.local_image_path, image_path)
            
            prompt= construct_query_MMstar(question,select_random_choice(answer,4))

            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{temp_image_path}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=temp_image_path,temperature=args.tempeature)

            response = extract_option(response_temp, question)
            
            answer_data_json = {
                'index': index,
                'image' : temp_image_path,
                'question': question,
                'answer' : answer,
                'response': response,
                'response_temp': response_temp,
                'category' : category ,
                'l2_category': l2_category,
                'meta_info': meta_info ,
                'prompt':prompt
            }


            answer_new_F_F.append(answer_data_json)

        save_path= cacluate_current_time_save_path('false_false',args)
        json.dump( answer_new_F_F , open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)

        consistent_ratio_false_true, inconsistent_ratio_false_true = calculate_consistency_MC(answer_new_F_F,'False->False-')



    for i in range(1):
        answer_T_F =[]
        for qid, item in enumerate(tqdm(filtered_data_true_false, desc="True->False")):
            index = item["index"]
            question = item["question"]
            image = item["image"]
            answer = item["answer"]
            category = item["category"]
            l2_category = item["l2_category"]
            meta_info = item["meta_info"]
            image_path = meta_info['image_path']

            temp_image_path = os.path.join(args.local_image_path, image_path)
            
            prompt= construct_query_MMstar(question,select_random_choice(answer,4))

            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{temp_image_path}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=temp_image_path,temperature=args.tempeature)

            response = extract_option(response_temp, question)
            
            answer_data_json = {
                'index': index,
                'image' : temp_image_path,
                'question': question,
                'answer' : answer,
                'response': response,
                'response_temp': response_temp,
                'category' : category ,
                'l2_category': l2_category,
                'meta_info': meta_info ,
                'prompt':prompt
            }


            answer_T_F .append(answer_data_json)

        save_path= cacluate_current_time_save_path('true_false',args)
        json.dump(  answer_T_F , open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)
        consistent_ratio_true_false, inconsistent_ratio_true_false = calculate_consistency_MC( answer_T_F , 'True->False')

    for i in range(1):
        answer_T_T = []
        for qid, item in enumerate(tqdm(filtered_data_true_false, desc="True->True")):
            index = item["index"]
            question = item["question"]
            image = item["image"]
            answer = item["answer"]
            category = item["category"]
            l2_category = item["l2_category"]
            meta_info = item["meta_info"]
            image_path = meta_info['image_path']

            temp_image_path = os.path.join(args.local_image_path, image_path)
            
            prompt= construct_query_MMstar(question,answer)

            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{temp_image_path}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=temp_image_path,temperature=args.tempeature)

            response = extract_option(response_temp, question)
            
            answer_data_json = {
                'index': index,
                'image' : temp_image_path,
                'question': question,
                'answer' : answer,
                'response': response,
                'response_temp': response_temp,
                'category' : category ,
                'l2_category': l2_category,
                'meta_info': meta_info ,
                'prompt':prompt
            }

            answer_T_T.append(answer_data_json)

        save_path= cacluate_current_time_save_path('true_true',args)
        json.dump(answer_T_T, open(save_path, 'w',encoding='utf-8'),
                        indent=2, ensure_ascii=False)
        consistent_ratio_true_false, inconsistent_ratio_true_false = calculate_consistency_MC(answer_T_T, 'True->True')