import json
from tqdm import tqdm
from swift.llm import (
        get_model_tokenizer, get_template, inference, ModelType,
        get_default_template_type, inference_stream
    )
from swift.utils import seed_everything
import logging
from .utils import *



def CoBench_YN(args,val_data, model, template ):
    seed_everything(42)
    args.local_image_path = '/Uncertainty_MLLMs/CoBench/test_YN'
    answer_all=[]
    for idx, item in enumerate(tqdm(val_data, desc="Processing items")):
        item['index'] = item.pop("image_id")
        index = item['index']
        question = item["question"]
        answer = item["answer"]
        question_id = item["question_id"]
        question_field = item["question_field"]
        field=item['field']
        image = os.path.join(args.local_image_path, index) +'.jpg'

        prompt= SYSTEM_MSG_YN+question
        if args.api_model:
            response_temp = get_all_model_api_result(args, prompt, image)
        elif args.model_type == 'phi3-vision-128k-instruct':
            prompt = f'<img>{image}</img>{prompt}'
            response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
        else :
            response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
        
        response=response_temp

        answer_data_json = {
            'index': index,
            'question': question,
            'answer' : answer,
            'response': response,
            'response_temp': response_temp,
            'question_id' : question_id,
            'question_field' : question_field,
            'prompt': prompt,
            'field':field
        }

        answer_all.append(answer_data_json)

    save_path = cacluate_current_time_save_path('all', args)
    json.dump(answer_all, open(save_path, 'w', encoding='utf-8'),
                      indent=2, ensure_ascii=False)
    consistent_ratio_all, inconsistent_ratio_all = calculate_consistency_YN(answer_all,'All data-')

    filtered_data_false_true = []
    filtered_data_true_false = []

    for item in answer_all:
        response = item['response'].strip().lower()
        true_answer = item['answer'].strip().lower()
    
        if 'yes' in response:
            response = 'yes'
        elif 'no' in response:
            response = 'no'
        
        if response == true_answer:
            filtered_data_true_false.append(item)
        elif response != true_answer:
            filtered_data_false_true.append(item)
        else:
            print('ERROR! ERROR!')

    save_path= cacluate_current_time_save_path('all_false',args)
    json.dump(filtered_data_false_true, open(save_path, 'w', encoding='utf-8'),
                        indent=2, ensure_ascii=False)

    save_path= cacluate_current_time_save_path('all_true',args)
    json.dump(filtered_data_true_false, open(save_path, 'w', encoding='utf-8'),
                        indent=2, ensure_ascii=False)
    

    logging.info(f"False Count: {len(filtered_data_false_true)}")
    for i in range(1):
        answer_F_T = []
        for qid, item in enumerate(tqdm(filtered_data_false_true, desc="false->True")):
            index = item['index']
            question = item["question"]
            answer = item["answer"]
            question_id = item["question_id"]
            question_field = item["question_field"]
            field=item['field']
            image = os.path.join(args.local_image_path, index) +'.jpg'

            prompt= SYSTEM_MSG_YN+question + construct_query_YN(answer)
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{image}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
            
            response=response_temp

            answer_data_json = {
                'index': index,
                'question': question,
                'answer' : answer,
                'response': response,
                'response_temp': response_temp,
                'question_id' : question_id,
                'question_field' : question_field,
                'prompt': prompt,
                'field':field
            }

            answer_F_T.append(answer_data_json)

        save_path= cacluate_current_time_save_path('false_true',args)
        json.dump(answer_F_T, open(save_path, 'w', encoding='utf-8'),
                        indent=2, ensure_ascii=False)

        consistent_ratio_false_true, inconsistent_ratio_false_true = calculate_consistency_YN(answer_F_T,'False->True-')


    logging.info(len(filtered_data_false_true))
    for i in range(1):
        answer_F_F=[]
        for qid, item in enumerate(tqdm(filtered_data_false_true, desc="False->False")):
            
            index = item['index']
            question = item["question"]
            answer = item["answer"]
            question_id = item["question_id"]
            question_field = item["question_field"]
            field=item['field']
            image = os.path.join(args.local_image_path, index) +'.jpg'
            
            if  answer == 'No':
                temp_answer_value = 'Yes'
            else:
                temp_answer_value = 'No'
            prompt= SYSTEM_MSG_YN+question + construct_query_YN(temp_answer_value)
            
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{image}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
            
            response=response_temp

            answer_data_json = {
                'index': index,
                'question': question,
                'answer' : answer,
                'response': response,
                'response_temp': response_temp,
                'question_id' : question_id,
                'question_field' : question_field,
                'prompt': prompt,
                'field':field
            }
            answer_F_F.append(answer_data_json)

        save_path= cacluate_current_time_save_path('false_false',args)
        json.dump(answer_F_F, open(save_path, 'w', encoding='utf-8'),
                        indent=2, ensure_ascii=False)

        consistent_ratio_false_true, inconsistent_ratio_false_true = calculate_consistency_YN(answer_F_F,'False->False-')

    logging.info(len(filtered_data_true_false))
    for i in range(1):
        answer_new_T_F = []
        for qid, item in enumerate(tqdm(filtered_data_true_false, desc="True->False")):
            index = item['index']
            question = item["question"]
            answer = item["answer"]
            question_id = item["question_id"]
            question_field = item["question_field"]
            field=item['field']
            image = os.path.join(args.local_image_path, index) +'.jpg'
            if  answer == 'No':
                temp_answer_value = 'Yes'
            else:
                temp_answer_value = 'No'

            prompt= SYSTEM_MSG_YN+ question + construct_query_YN(temp_answer_value)
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{image}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
            
            response=response_temp
            answer_data_json = {
                'index': index,
                'question': question,
                'answer' : answer,
                'response': response,
                'response_temp': response_temp,
                'question_id' : question_id,
                'question_field' : question_field,
                'prompt': prompt,
                'field':field
            }

            answer_new_T_F.append(answer_data_json)

        save_path= cacluate_current_time_save_path('true_false',args)
        json.dump(answer_new_T_F, open(save_path, 'w', encoding='utf-8'),
                        indent=2, ensure_ascii=False)
        consistent_ratio_true_false, inconsistent_ratio_true_false = calculate_consistency_YN(answer_new_T_F, 'True->False')


    logging.info(len(filtered_data_true_false))
    for i in range(1):
        answer_new_T_T=[]
        for qid, item in enumerate(tqdm(filtered_data_true_false, desc="True->True")):
            index = item['index']
            question = item["question"]
            answer = item["answer"]
            question_id = item["question_id"]
            question_field = item["question_field"]
            field=item['field']
            image = os.path.join(args.local_image_path, index) +'.jpg'
            prompt=  SYSTEM_MSG_YN+question + construct_query_YN(answer)
            if args.api_model:
                response_temp = get_all_model_api_result(args, prompt, image)
            elif args.model_type == 'phi3-vision-128k-instruct':
                prompt = f'<img>{image}</img>{prompt}'
                response_temp, _ = inference(model, template, prompt, temperature=args.tempeature)
            else :
                response_temp, _ = inference(model, template, prompt, images=image,temperature=args.tempeature)
            
            response=response_temp

            answer_data_json = {
                'index': index,
                'question': question,
                'answer' : answer,
                'response': response,
                'response_temp': response_temp,
                'question_id' : question_id,
                'question_field' : question_field,
                'prompt': prompt,
                'field':field
            }

            answer_new_T_T.append(answer_data_json)

        save_path= cacluate_current_time_save_path('true_true',args)
        json.dump(answer_new_T_T, open(save_path, 'w', encoding='utf-8'),
                        indent=2, ensure_ascii=False)
        consistent_ratio_true_false, inconsistent_ratio_true_false = calculate_consistency_YN(answer_new_T_T, 'True->True')
