import argparse
import os
from pathlib import Path
import subprocess
import sys
home = str(Path.home())
script_name = 'rendering_test.py'
blender_path = "/Applications/Blender.app/Contents/MacOS/Blender"
blender_path = "DISPLAY=:20 blender"

p = argparse.ArgumentParser(description='Renders given obj file by rotation a camera around it.')
p.add_argument('--num_observations', type=int, required=True, help='The path the output will be dumped to.')
p.add_argument('--resolution', type=int, required=True, help='The path the output will be dumped to.')
p.add_argument('--sphere_radius', type=float, required=True, help='The path the output will be dumped to.')
p.add_argument('--sampling_mode', type=str, required=True, help='Options: sample_spherical, get_archimedean_spiral, and z_height_constant')
p.add_argument('--background_color', type=str, required=True, help='Options: white and black')
p.add_argument('--save_dir', type=str, required=True, help='The path the output will be dumped to.')
p.add_argument('--model_data_dir', type=str, required=True, help='The path for blender files.')
p.add_argument('--write_z_buffer', action='store_true', default=False, help='If you want to save depth map as well')
p.add_argument('--scale_x', type=float, required=True, help='Scale the object in x-axis.')
p.add_argument('--scale_y', type=float, required=True, help='Scale the object in y-axis.')
p.add_argument('--scale_z', type=float, required=True, help='Scale the object in z-axis.')

args = p.parse_args()

if args.model_data_dir == '/app/geon_model':
    script_name = '/app/rendering_test.py'

for model_name in os.scandir(args.model_data_dir): 
    print(model_name.path)
    
    cmd = blender_path + " -b " +  model_name.path + " -P " \
    + script_name + " -- --background_color " + args.background_color \
    + " --num_observations " + str(args.num_observations) \
    + " --sampling_mode " + args.sampling_mode \
    + " --sphere_radius " + str(args.sphere_radius) \
    + " --save_dir " + args.save_dir \
    + " --resolution " + str(args.resolution) \
    + " --scale_x " + str(args.scale_x) \
    + " --scale_y " + str(args.scale_y) \
    + " --scale_z " + str(args.scale_z)
    if args.write_z_buffer:
        cmd += " --write_z_buffer"
    subprocess.call(cmd, shell=True)
