
This repository provides the **testing framework** for our registration method on the [EPFL Electron Microscopy Hippocampus dataset](https://www.epfl.ch/labs/cvlab/data/data-em/). The code is intended to demonstrate the **correctness and effectiveness** of our paradigm.

> ⚠️ Note: We only provide partial test code here, with some core components intentionally omitted. Full source code will be released upon paper acceptance.


Please download the `volumedata.tif` file from:

📎 https://www.epfl.ch/labs/cvlab/data/data-em/

Then convert it into PNG slices (1065 slices) and place them in the following folder structure:

```

data/raw/
├── 0000.png
├── 0001.png
├── ...

````

---

We provide a one-click shell script to run the full pipeline:

```bash
bash run.sh
````

The script performs the following steps:

1. **Data Preparation**
   Generate distorted images from raw input:

   ```bash
   python make_data.py
   ```

2. **Run Registration**
   Apply our registration method on the distorted data:

   ```bash
   python test_reg.py
   ```

You can use FIJI's visualization tools to view the registration results.

We provide side-view visualizations of the data before and after registration using FIJI, to demonstrate the effectiveness of our method.

**Figure 1**: Side view of the data **before registration**  
![Before Registration](fig/raw.png)

**Figure 2**: Side view of the data **after registration**  
![After Registration](fig/reg.png)

