## Files:

1. **gen_responses.py**: This script generates responses from a given prompt set sourced from Hugging Face. The generated responses are then uploaded to Hugging Face. Configuration details can be found in `gen_responses_conf.yaml`.
You need to duplicate the `.env.example` with a `.env` file and add your openrouter key to generate responses.

2. **gen_rewards.py**: This script generates rewards for each (prompt, response) pair using ONE reward model. The generated rewards are subsequently uploaded to Hugging Face. Configuration details can be found in `gen_rewards_conf.yaml`.

3. **gen_all_rewards.py**: This script generates rewards for each (prompt, response) pair using all the reward models from PersonalLLM. The generated rewards are subsequently uploaded to Hugging Face. Configuration details can be found in `gen_all_rewards_conf.yaml`.
`python gen_all_rewards.py --conf_filepath path/to/config.yaml --dataset_name your_dataset_name --output_dataset_name your_output_dataset_name`

![Figure](../assets/metalearn_fig.png)

4. **gen_personas.ipynb**: This script generates a Dirichlet weighted ensemble of personalities using multiple reward models. It's worth noting that both `gen_pref_interaction_database` and `gen_reward_interaction_database` inherently include this functionality.

5. **meta_learning.py**: This script generates a meta-learning database of previous user interactions for a given dataset. Refer to Section 4.2 of the paper for more details. 