#!/bin/bash
#SBATCH --job-name=ema_p1
#SBATCH --partition=gpuv100
#SBATCH --nodes=1
#SBATCH --mem=20gb
#SBATCH --cpus-per-task 8
#SBATCH --gres=gpu:1
#SBATCH --time=2-00:00:00
#SBATCH --output /mmfs1/data/fangxian/ICML2025/slurm/CIFAR10/ema_result_p1.out
#SBATCH --error /mmfs1/data/fangxian/ICML2025/slurm/CIFAR10/ema_error_p1.out

conda activate share_VAR 
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=ema_quantizer --dataset_name=CIFAR10 --batch_size 128 --factor 4 --codebook_size 32768   --beta=1.0 --gamma=0.0
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=ema_quantizer --dataset_name=CIFAR10 --batch_size 128 --factor 4 --codebook_size 16384   --beta=1.0 --gamma=0.0
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=ema_quantizer --dataset_name=CIFAR10 --batch_size 128 --factor 4 --codebook_size 8192    --beta=1.0 --gamma=0.0
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=ema_quantizer --dataset_name=SVHN --batch_size 128 --factor 4 --codebook_size 32768   --beta=1.0 --gamma=0.0
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=ema_quantizer --dataset_name=SVHN --batch_size 128 --factor 4 --codebook_size 16384   --beta=1.0 --gamma=0.0
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=ema_quantizer --dataset_name=SVHN --batch_size 128 --factor 4 --codebook_size 8192   --beta=1.0 --gamma=0.0