#!/bin/bash
#SBATCH --job-name=wasserstein_p3
#SBATCH --partition=gpuv100
#SBATCH --nodes=1
#SBATCH --mem=20gb
#SBATCH --cpus-per-task 8
#SBATCH --gres=gpu:1
#SBATCH --time=2-00:00:00
#SBATCH --output /mmfs1/data/fangxian/ICML2025/slurm/CIFAR10/wasserstein_result_p3.out
#SBATCH --error /mmfs1/data/fangxian/ICML2025/slurm/CIFAR10/wasserstein_error_p3.out

conda activate share_VAR 
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=wasserstein_quantizer --dataset_name=CIFAR10 --batch_size 128 --factor 4 --codebook_size 16384   --beta=0.01 --gamma=0.5 --codebook_dim 2
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=wasserstein_quantizer --dataset_name=CIFAR10 --batch_size 128 --factor 4 --codebook_size 16384   --beta=0.01 --gamma=0.5 --codebook_dim 4
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=wasserstein_quantizer --dataset_name=CIFAR10 --batch_size 128 --factor 4 --codebook_size 16384   --beta=0.01 --gamma=0.5 --codebook_dim 16
CUDA_VISIBLE_DEVICES="0" python train_vqvae.py --quantizer_name=wasserstein_quantizer --dataset_name=CIFAR10 --batch_size 128 --factor 4 --codebook_size 16384   --beta=0.01 --gamma=0.5 --codebook_dim 32