import numpy as np

class ELU():
    alpha = 1.0
    """
    smooth, y-range [-alpha, inf], vanishing gradient for x<<0 with exponential decay, high computationally expensive
    """
    @staticmethod
    def f(x):
        return np.where(x > 0, x, ELU.alpha * (np.exp(x) - 1))

    @staticmethod
    def df(x, order=1):
        match order:
            case 1:
                return np.where(x > 0, 1, ELU.alpha * np.exp(x))
            case 2:
                return np.where(x > 0, 0, ELU.alpha * np.exp(x))
            case _:
                raise NotImplementedError(f"ELU gradient order {order} is not implemented yet")
