import numpy as np

class ReLU():
    """
    piecewise, y-range [0, inf], vanishing gradient at hard cutoff when x<0, very low computationally expensive
    """
    @staticmethod
    def f(x):
        return np.maximum(0., x)
        # return x * (x > 0)
    @staticmethod
    def df(x, order=1):
        match order:
            case 1:
                return np.where(x > 0, 1, 0)
            case 2:
                return np.zeros_like(x)
            case _:
                raise NotImplementedError(f"ReLU gradient order {order} is not implemented yet")
