import numpy as np

class Tanh():
    """
    Smooth, y-range [-1, 1], vanishing gradient at exponential decay, moderate computationally expensive
    """
    @staticmethod
    def f(x):
        return np.tanh(x)
    @staticmethod
    def df(x, order=1):
        match order:
            case 1:
                return 1 - np.tanh(x)**2
                # return 1 / np.cosh(x)**2
            case 2:
                return -2 * np.sinh(x) / np.cosh(x)**3
            case _:
                raise NotImplementedError(f"Tanh gradient order {order} is not implemented yet")

