from enum import StrEnum

class MeshType(StrEnum):
    RECTANGULAR = "rectangular"
    DIAGONAL    = "diagonal"
    CROSS       = "cross"

class Mesh:
    def __init__(self, mesh_type: MeshType):
        if mesh_type not in {MeshType.RECTANGULAR, MeshType.DIAGONAL}: # FIXME: add 'CROSS' after implementing it
            raise NotImplementedError(f"Meshing {mesh_type} is unknown or not implemented yet")
        self.mesh_type: MeshType = mesh_type

    def has_xy_springs(self) -> bool:
        if self.mesh_type in {MeshType.RECTANGULAR, MeshType.DIAGONAL, MeshType.CROSS}:
            return True
        else:
            return False

    def has_down_diag(self) -> bool:
        if self.mesh_type in {MeshType.DIAGONAL, MeshType.CROSS}:
            return True
        else:
            return False

    def has_up_diag(self) -> bool:
        if self.mesh_type in {MeshType.CROSS}:
            return True
        else:
            return False

