import numpy as np

def hamiltons_eq(dedx: np.ndarray) -> np.ndarray:
    """
    Returns dxdt using Hamilton's equations
    Args:
        dedx: gradient of Hamiltonian of system of shape (..., 2*dof)
        where q and p gradients are stacked at axis=-1
    Return:
        dxdt: time derivatives of the same shape as dedx
    """
    assert dedx.shape[-1] % 2 == 0, "2*dof expected in the last dimension"
    dof = dedx.shape[-1] // 2
    dedq, dedp = dedx[..., :dof], dedx[..., dof:]
    dqdt, dpdt = dedp, -dedq
    return np.concatenate([dqdt, dpdt], axis=-1)
