def linear_lr_lambda(n_steps, lr_start, lr_end):
    slope = (lr_end - lr_start) / n_steps
    lr_lambda = lambda step: (lr_start + slope * step) / lr_start
    return lr_lambda

def exponential_lr_lambda(n_steps, lr_start, lr_end):
    """
    Returns lambda function to be used with LRLambda that does exponential decaying of the learning rate.
    """
    decay_rate = (lr_end / lr_start) ** (1 / n_steps)
    lr_lambda = lambda step: decay_rate ** step
    return lr_lambda
