import numpy as np

def rotate_2d(vec: np.ndarray, angle_rad: float, dtype_np) -> np.ndarray:
    rot = np.array([
        [np.cos(angle_rad), -np.sin(angle_rad)],
        [np.sin(angle_rad),  np.cos(angle_rad)]
        ], dtype=dtype_np)
    return vec @ rot.T
