# Configuration File Format Documentation

This document describes the structure and parameters of the configuration files (.json format) used in the VFedCD project. All configurations are stored in the src/configs/ directory. Below is a detailed breakdown of each section and its parameters.


## 1. Basic Settings
### Overview
This section defines fundamental parameters for training, parties, and data.

### Structure
{   
&emsp;"epochs": 0,    
&emsp;"lr": 0.01,   
&emsp;"optim": "SGD",     
&emsp;"k": 2,   
&emsp;"batch_size": 16,   
&emsp;"dataset": {    
&emsp;&emsp;"dataset_name": "observational",    
&emsp;&emsp;"n_train": 800,   [READMDME.md](..%2F..%2FREADMDME.md)
&emsp;&emsp;"n_test": 200,    
&emsp;&emsp;"dims": [7,8]   
&emsp;}   
}

### Fields
| Parameter               | Type          | Description                                                                           | Example Values  |
|-------------------------|---------------|---------------------------------------------------------------------------------------|-----------------|
| `epochs`                | Integer       | Number of iterations (each iteration = 1 communication round, with Q dataset epochs). | `500`           |
| `lr`                    | List[Float]   | Learning rate(s) for two stages.                                                      | `[0.02,0.01]`   |
| `optim`                 | String        | Optimizer name (e.g., "SGD", "Adam").                                                 | "SGD"           |
| `k`                     | Integer       | Number of participating parties (clients).                                            | `2`             |
| `batch_size`            | Integer       | Number of samples per training batch.                                                 | `32`            |
| `dataset.dataset_name`  | String        | Alias for the dataset (for logging/record-keeping).                                   | "observational" |
| `dataset.n_train`       | Integer       | Number of training samples.                                                           | `800`           |
| `dataset.n_test`        | Integer       | Number of test samples.                                                               | `200`           |
| `dataset.dims`          | List[Integer] | Attribute split (how many attributes each party has).                                 | [7, 8]          |


## 2. Causal Inference Parameters (`causal`)
### Overview
This section configures hyperparameters for causal structure learning, including penalties, thresholds, and masking.

### Structure
{   
&emsp;"causal": {   
&emsp;&emsp;"alpha": [0, 0],    
&emsp;&emsp;"beta": [0, 0],   
&emsp;&emsp;"eta": [0.0002, 0.005],   
&emsp;&emsp;"gamma_from": [0, 0],   
&emsp;&emsp;"gamma_increase": [0, 0.006],   
&emsp;&emsp;"threshold": [0.1, 0.1],    
&emsp;&emsp;"mask_threshold": [0.2, 0.1],   
&emsp;&emsp;"mask": ["none", "none"],   
&emsp;&emsp;"dag_penalty_flavor": ["none", "power_iteration"],    
&emsp;&emsp;"power_iteration_n_steps": [5, 15],   
&emsp;&emsp;"freeze_gamma_at_dag": [0, 1],    
&emsp;&emsp;"freeze_gamma_threshold": [0, 0.001],   
&emsp;&emsp;"skip_s1": 1,   
&emsp;&emsp;"aggregate": "add",   
&emsp;&emsp;"adj_p": 1.0    
&emsp;}   
}

### Fields
| Parameter                 | Type          | Description                                                              | Example Values              |
|---------------------------|---------------|--------------------------------------------------------------------------|-----------------------------|
| `alpha`/`beta`/`eta`      | List[Float]   | Regularization coefficients.                                             | 0/0/0.005                   |
| `gamma_from`              | List[Float]   | Initial values for gamma (DAG penalty parameters).                       | [0, 0]                      |
| `gamma_increase`          | List[Float]   | Increment step for gamma during training.                                | [0, 0.006]                  |
| `threshold`               | List[Float]   | Threshold for causal edge significance (pruning).                        | [0.1, 0.1]                  |
| `mask_threshold`          | List[Float]   | Threshold for edge masking (e.g., in mask matrices).                     | [0.2, 0.1]                  |
| `mask`                    | List[String]  | Edge masking strategy (`"none"` for no prior mask).                      | ["none", "none"]            |
| `dag_penalty_flavor`      | List[String]  | DAG constraint method (`"none"` for no DAG constraints).                 | ["none", "power_iteration"] |
| `power_iteration_n_steps` | List[Integer] | Steps for power iteration (when `dag_penalty_flavor="power_iteration"`). | [5, 15]                     |
| `freeze_gamma_at_dag`     | List[Integer] | Freeze gamma when DAG constraint is satisfied (0=off, 1=on).             | [0, 1]                      |
| `freeze_gamma_threshold`  | List[Float]   | Threshold for freezing gamma.                                            | [0, 0.001]                  |
| `skip_s1`                 | Integer       | Skip first stage of causal learning (0=execute, 1=skip).                 | `1`                         |
| `aggregate`               | String        | Aggregation method for features (`"add"`, `"mean"`).                     | "add"                       |
| `adj_p`                   | Float         | Norm dimension for extracting adjacency matrix from parameters.          | `1.0`                       |


## 3. Model Configuration (`model_list`)
### Overview
Defines the architecture of each party's model. Each party is indexed by a number (e.g., `"0"`, `"1"`).

### Structure
{
  "model_list": {
    "0": {
      "type": "VFedCD",
      "hidden_dim":  [10]
    },
    "1": {
      "type": "VFedCD",
      "hidden_dim": [10]
    },
    "apply_trainable_layer": 1
  }
}

### Fields
| Parameter               | Type          | Description                                                | Example Values |
|-------------------------|---------------|------------------------------------------------------------|----------------|
| `type`                  | String        | Model type (e.g., `"VFedCD"`).                             | "VFedCD"       |
| `hidden_dim`            | List[Integer] | Hidden layer dimensions (e.g., for neural networks).       | [10]           |
| `apply_trainable_layer` | Integer       | Enable/disable trainable layers (0=off, 1=on).             | `1`            |


## 4. Communication Settings
### Overview
Configures communication protocols between parties and the server.

### Structure
{
  "communication": {
    "communication_protocol": "FedBCD_p",
    "iteration_per_aggregation": 1
  },
  "server_communication": {
    "communication_protocol": "FedBCD_p"
  }
}

### Fields
| Parameter                        | Type          | Description                                                                | Example Values               |
|----------------------------------|---------------|----------------------------------------------------------------------------|------------------------------|
| `communication_protocol`         | String        | Communication protocol (e.g., `"FedBCD_p"`).                               | "FedBCD_p"                   |
| `iteration_per_aggregation`      | Integer       | Communication cycle (Q): number of local iterations between communication. | `1`                          |


## 5. Path Settings
### Overview
Specifies file paths for datasets and output logs/results.

### Structure
{
  "data_path": "../share_dataset/4/",
  "save_path": "log/vfedcd_4_e500"
}

### Fields
| Parameter       | Type          | Description                                                          | Example Values        |
|-----------------|---------------|----------------------------------------------------------------------|-----------------------|
| `data_path`     | String        | Path to the dataset directory (relative to project root).            | "../share_dataset/4/" |
| `save_path`     | String        | Path to save logs and experiment results (relative to `src/`).       | "log/vfedcd_4_e500"   |


## Example Configuration Template
{
  "epochs": 500,
  "lr": [0.01, 0.001],
  "optim": "Adam",
  "k": 3,
  "batch_size": 32,
  "dataset": {
    "dataset_name": "synthetic_data",
    "n_train": 1000,
    "n_test": 200,
    "dims": [5, 3]
  },
  "causal": {
    "alpha": [0.5, 0.5, 0.5],
    "beta": [0.2, 0.2, 0.2],
    "mask": ["fixed", "fixed", "none"]
  },
  "model_list": {
    "0": {"type": "VFedCD", "hidden_dim": [16]},
    "1": {"type": "VFedCD", "hidden_dim": [16]},
    "2": {"type": "VFedCD", "hidden_dim": [16]}
  },
  "communication": {
    "communication_protocol": "FedBCD_p",
    "iteration_per_aggregation": 5
  },
  "data_path": "../share_dataset/3/",
  "save_path": "log/vfedcd_3_e500"
}
