import os

import numpy as np
import pandas as pd

import random
import torch

def generate_observational_dataset(
    save_dir=None,
):
    assert save_dir is not None, "No dataset input"
    if save_dir is not None:
        X_path = os.path.join(save_dir, "X.csv")
        Btrue_path = os.path.join(save_dir, "Btrue.csv")
        assert os.path.exists(X_path) and os.path.exists(Btrue_path), "No X or Btrue found in {}".format(save_dir)
        X = pd.read_csv(X_path, index_col=0)
        B_true = np.loadtxt(Btrue_path, delimiter=",").astype(np.int64)
        return X, B_true
    else:
        raise ValueError("should use save_dir")

def set_random_seed_all(seed=0):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    # torch.cuda.manual_seed(seed)
