import argparse
import pandas as pd
import matplotlib.pyplot as plt
import numpy as np

# 创建参数解析器
parser = argparse.ArgumentParser(description='F1 score for different Split position')
parser.add_argument('--file', type=str, required=True, help='输入文件路径')
args = parser.parse_args()

# 读取文件
excel_file = pd.ExcelFile(args.file)

# 获取对应工作表中数据
df = excel_file.parse('Sheet1')

# 设置图片清晰度
plt.rcParams['figure.dpi'] = 300

# 设置字体大小和加粗
plt.rcParams['font.size'] = 17
plt.rcParams['font.weight'] = 'bold'

# 获取绘图数据
categories = df['Unnamed: 0']
split_positions = df.columns[1:]

# 设置柱的宽度
bar_width = 0.45
index = np.arange(len(split_positions))

# 绘制 inter edge f1 的柱
bars1 = plt.bar(index, df.loc[0, split_positions], bar_width, label='inter edge f1')

# 绘制 intra edge f1 的柱
bars2 = plt.bar(index + bar_width, df.loc[1, split_positions], bar_width, label='intra edge f1')

# 在柱子上标注数值
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        plt.annotate(f'{height:.2f}',
                     xy=(bar.get_x() + bar.get_width() / 2, height),
                     xytext=(0, 3),  # 3 points vertical offset
                     textcoords="offset points",
                     ha='center', va='bottom',
                     fontsize=15, fontweight='bold')

add_labels(bars1)
add_labels(bars2)

# 设置坐标轴标签
plt.xlabel('Split Position', fontweight='bold')
plt.xticks(index + bar_width / 2, ["A", "B", "C", "D"])
plt.ylabel('F1 score', fontweight='bold')

# 设置纵坐标范围从 0.5 开始
plt.ylim(0.5, 0.9)

# 显示图例
plt.legend()
plt.tight_layout()

# 显示图表
plt.show()