import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 345
        self.name = "reverse_voewls"
        self.description = '''Given a string s, reverse only all the vowels in the string and return it. And the vowels can appear in both lower and upper cases, more than once.'''
        self.url = '''https://leetcode.com/problems/reverse-vowels-of-a-string/description/'''
        self.rule = '''
def reverse_voewls(s: str) -> str
    len_s = len(s)
    s_list = list(s)
    voewls = 'aeiou'
    result1 = []
    result2 = []
    voewl = []
    i = 0
    while i<len_s:
        s_pop = s_list.pop()
        if s_pop.lower() in voewls:
            voewl.append(s_pop)
            result1.append(' ')
        else:
            result1.append(s_pop)
        i+=1
    voewl.reverse()
    i = 0
    while i<len_s:
        result1_pop = result1.pop()
        if result1_pop == ' ':
            result2.append(voewl.pop())
        else:
            result2.append(result1_pop)
        i += 1
    final = ''.join(result2)
    return final'''
        self.initialize = '''
1. Initialize s State
```
len_s = len(s)
```
len_s = len('{}') = {}
```
s_list = list(s)
```
s_list = {}
```
voewls = 'aeiou'
```
```
result1 = []
```
```
result2 = []
```
```
voewl = []
```
```
i = 0
```
2. Main Loop 1'''
        self.one_iteration_2_1_replace = '''
2.{} one iteration
```
while i<len_s:
```
i = {}
len_s = {}
i < len_s
enter
```
s_pop = s_list.pop()
```
s_pop = '{}'
```
if s_pop.lower() in voewls:
```
s_pop.lower() = '{}'
voewls = '{}'
s_pop.lower() in voewls
enter
```
voewl.append(s_pop)
```
voewl = {}
```
result1.append(' ')
```
result1 = {}
```
i+=1
```
i = {}'''
        self.one_iteration_2_1_not_replace = '''
2.{} one iteration
```
while i<len_s:
```
i = {}
len_s = {}
i < len_s
enter
```
s_pop = s_list.pop()
```
s_pop = '{}'
```
if s_pop.lower() in voewls:
```
s_pop.lower() = '{}'
voewls = '{}'
s_pop.lower() not in voewls
not enter
```
else:
    result1.append(s_pop)
```
result1 = {}
```
i+=1
```
i = {}'''
        self.not_enter_loop1 = '''
2.{} one iteration
```
while i<len_s:
```
i = {}
len_s = {}
i >= len_s
not enter'''
        self.reverse_3 = '''
3. Reverse
```
voewl.reverse()
```
voewl = voewl.reverse() = {}
```
i = 0
```'''
        self.one_iteration_4_1_replace = '''
4.{} one iteration
```
while i<len_s:
```
i = {}
len_s = {}
i < len_s
enter
```
result1_pop = result1.pop()
```
result1_pop = '{}'
```
if result1_pop == ' ':
```
result1_pop == ' '
enter
```
result2.append(voewl.pop())
```
result2 = result2.append('{}') = {}
```
i+=1
```
i = {}'''
        self.one_iteration_4_1_not_replace = '''
4.{} one iteration
```
while i<len_s:
```
i = {}
len_s = {}
i < len_s
enter
```
result1_pop = result1.pop()
```
result1_pop = '{}'
```
if result1_pop == ' ':
```
result1_pop != ' '
not enter
```
else:
    result2.append(result1_pop)
```
result2 = result2.append('{}') = {}
```
i+=1
```
i = {}'''
        self.not_enter_loop2 = '''
4.{} one iteration
```
while i<len_s:
```
i = {}
len_s = {}
i >= len_s
not enter'''
        self.return_result = '''
5. Return Result
```
final = ''.join(result2)
```
result2 = {}
final = '{}'
```
return final
```
So the answer is '{}'.'''


    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s"
        '''
        import string
        Alphabet = string.ascii_letters
        s = ''.join(random.choices(Alphabet, k=length))
        question = f"s = '{s}'. Reverse only all the vowels in the string. What's the result?"
        return {"question": question,
                "s": s}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        s = data['s']
        s_list = list(s)
        len_s = len(s)
        voewls = 'aeiou'
        result1 = []
        result2 = []
        voewl = []
        i = 0
        output = self.initialize.format(s,len_s,s_list)
        while i<len_s:
            s_pop = s_list.pop()
            if s_pop.lower() in voewls:
                voewl.append(s_pop)
                result1.append(' ')
                output += self.one_iteration_2_1_replace.format(i+1,i,len_s,s_pop,s_pop.lower(),voewls,voewl,result1,i+1)
            else:
                result1.append(s_pop)
                output += self.one_iteration_2_1_not_replace.format(i+1,i,len_s,s_pop,s_pop.lower(),voewls,result1,i+1)
            i+=1
        if i>=len_s:
            output += self.not_enter_loop1.format(i,i,len_s)
        voewl.reverse()
        i = 0
        output += self.reverse_3.format(voewl)
        while i<len_s:
            result1_pop = result1.pop()
            if result1_pop == ' ':
                voewl_pop = voewl.pop()
                result2.append(voewl_pop)
                output += self.one_iteration_4_1_replace.format(i+1,i,len_s,result1_pop,voewl_pop,result2,i+1)
            else:
                result2.append(result1_pop)
                output += self.one_iteration_4_1_not_replace.format(i+1,i,len_s,result1_pop,result1_pop,result2,i+1)
            i += 1
        if i>=len_s:
            output += self.not_enter_loop2.format(i,i,len_s)
        final = ''.join(result2)
        output += self.return_result.format(result2,final,final)
        answer = final
        return {"input": input,
                "output": output,
                "answer": answer}
if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/0345.json", "w")
    file.write(data['input'] + data['output'] + data['answer'])
        
