import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 387
        self.name = "firstUniqChar"
        self.description = '''Given a string s, find the first non-repeating character in it and return its index. If it does not exist, return -1.'''
        self.url = '''https://leetcode.com/problems/first-unique-character-in-a-string/description/'''
        self.rule = r'''
def firstUniqChar(s: str) -> int
    dic = {}
    s_list = list(s)
    while s_list:
        c = s_list.pop(0)
        if c in dic:
            dic[c] = False
        else:
            dic[c] = True
    s_list = list(s)
    i = 0
    while s_list:
        c = s_list.pop(0)
        if dic[c]:
            return i
        i += 1
    return -1'''
        self.initialize_one = '''
1. Initialize one
```
dic = {}
```
```
s_list = list(s)
```
s_list = {}

2. Main Loop one'''
        self.one_iteration_2_1_storage_in = '''
2.{} one iteration
```
while s_list:
```
s_list = {}
enter
```
c = s_list.pop(0)
```
c = '{}'
```
if c in dic:
```
c = '{}'
c in dic
enter
```
dic[c] = False
```
dic['{}'] = {}'''
        self.one_iteration_2_1_storage_not_in = '''
2.{} one iteration
```
while s_list:
```
s_list = {}
enter
```
c = s_list.pop(0)
```
c = '{}'
```
if c in dic:
```
c = '{}'
c not in dic
not enter
```
else:
    dic[c] = True
```
dic['{}'] = {}'''
        self.not_enter_loop1 = '''
2.{} one iteration
```
while s_list:
```
s_list = {}
not enter'''
        self.Initialize_two = '''
3. Initialize two
```
s_list = list(s)
```
s_list = {}
```
i = 0
```
4. Main Loop two'''
        self.one_iteration_3_1_jugde_return_result = '''
4.{} one iteration
```
while s_list:
```
s_list = {}
enter
```
c = s_list.pop(0)
```
c = '{}'
```
if dic[c]:
```
dic[c] = dic['{}'] == True
enter
```
return i
```
return {}

So the answer is {}.'''
        self.one_iteration_3_1_jugde_not_return_result = '''
4.{} one iteration
```
while s_list:
```
s_list = {}
enter
```
c = s_list.pop(0)
```
c = '{}'
```
if dic[c]:
```
dic[c] = dic['{}'] == False
not enter
```
i += 1
```
i = {}'''
        self.not_enter_loop2 = '''
4.{} one iteration
```
while s_list:
```
s_list = {}
not enter'''
        self.return_result = '''
5. Return Result
```
return -1
```
So the answer is -1.'''


    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s"
        '''
        import string
        Alphabet = string.ascii_letters + string.digits
        s = ''.join(random.choices(Alphabet, k=length))
        question = f"Given a string s = '{s}'.Find the first non-repeating character in it and what's its index?"

        return {"question": question,
                "s": s}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        rule = self.rule
        instruction = "Follow the given rule to solve the question.\nrule:"
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        s = data['s']
        dic = {}
        s_list = list(s)
        output = self.initialize_one.format(dic,s_list)
        i = 0
        while s_list:
            s_list_copy = deepcopy(s_list)
            c = s_list.pop(0)
            if c in dic:
                dic[c] = False
                output += self.one_iteration_2_1_storage_in.format(i+1,s_list_copy,c,c,c,dic[c])
            else:
                dic[c] = True
                output += self.one_iteration_2_1_storage_not_in.format(i+1,s_list_copy,c,c,c,dic[c])
            i += 1
        if not s_list:
            output += self.not_enter_loop1.format(i,s_list)
        s_list = list(s)
        i = 0
        output += self.Initialize_two.format(s_list)
        while s_list:
            s_list_copy = deepcopy(s_list)
            c = s_list.pop(0)
            if dic[c]:
                output += self.one_iteration_3_1_jugde_return_result.format(i+1,s_list_copy,c,c,i,i)
                break
            else:
                output += self.one_iteration_3_1_jugde_not_return_result.format(i+1,s_list_copy,c,c,i+1)
            i += 1
        if not s_list:
            output += self.not_enter_loop2.format(i,s_list)
        if not dic[c]:
            output += self.one_iteration_3_1_jugde_return_result
            answer = -1
        else:
            answer = i
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(5)
    data = dg.rfft_IO(data)
    file = open("tasks/0387.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))