import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 388
        self.name = 'lengthLongestselfath'
        self.description = "What's the length of the longest absolute path to a file in the abstracted file system? If there is no file in the system, return 0."
        self.url = 'https://leetcode.com/problems/longest-absolute-file-path/'

        self.rule = '''
def lengthLongestselfath(self, input: str) -> int:
    line_list = input.split('\\n')
    level_length = []
    ans = 0
    while line_list:
        line = line_list.pop(0)
        level = line.count('\\t')
        count = len(line) - level + 1
        while len(level_length) > level:
            level_length.pop()
        if level_length:
            count += level_length[-1]
        if '.' in line:
            ans = max(ans,count-1)
        else:
            level_length.append(count)
    return ans'''
        self.initialize = '''
1. Initialize
```
line_list = input.split('\\n')
```
line_list = {}
```
level_length = []
```
```
ans = 0
```
2. Main loop'''
        self.interation_outer = '''
2.{} one interation
```
while line_list:
```
line_list = {}
enter
```
line = line_list.pop(0)
```
line = '{}'
```
level = line.count('\\t')
```
level = {}
```
count = len(line) - level + 1
```
count = {}
```'''
        self.interation_inner_in = '''
2.{}.{} one interation
```
while len(level_length) > level:
```
len(level_length) = {}
level = {}
len(level_length) > level
enter
```
level_length.pop()
```
level_length = {}
```'''
        self.interation_inner_not_in = '''
2.{}.{} one interation
```
while len(level_length) > level:
```
len(level_length) = {}
level = {}
len(level_length) <= level
not enter'''
        self.interation_one_in = '''
```
if level_length:
```
level_length = {}
enter
```
count += level_length[-1]
```
count = {}
```'''
        self.interation_one_not_in = '''
```
if level_length:
```
level_length = {}
not enter'''
        self.interation_two_in = '''
```
if '.' in line:
```
line = '{}'
'.' in line
enter
```
ans = max(ans,count-1)
```
ans = {}
```'''
        self.interation_two_not_in = '''
```
if '.' in line:
```
line = '{}'
'.' not in line
not enter
```
else:
    level_length.append(count)
```
level_length = {}'''
        self.not_enter_loop = '''
2.{} one interation
```
while line_list:
```
line_list = {}
not enter'''
        self.return_result = '''
3. Return result
```
return ans
```
So the answer is {}.'''


    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s","t"
        '''
        import string
        input = ''.join(['\\t'*i+''.join(random.choices(string.ascii_lowercase,k = random.choice(range(1,5))))+'\\n' for i in range(random.choice(range(0,4)))]+['\\t'*i+''.join(random.choices(string.ascii_lowercase + '.......',k = random.choice(range(1,5))))+'\\n' for i in range(random.choice(range(random.choice(range(1,3)),random.choice(range(4,5)))))])
        question = f'''input = "{input}". What's the length of the longest absolute path to a file in the abstracted file system? If there is no file in the system, return 0.'''
        return {"question": question,
                "input": input}
    
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        input_ = data["input"]
        line_list = input_.split(r'\n')
        level_length = []
        ans = 0
        output = self.initialize.format(line_list)
        i = 1
        while line_list:
            line_list_copy = deepcopy(line_list)
            line = line_list.pop(0)
            level = line.count('\\t')
            if not level:
                count = len(line)
            else:
                count = len(line) - level*2
            output += self.interation_outer.format(i,line_list_copy,line,level,count)
            j = 1
            if len(level_length) <= level:
                output += self.interation_inner_not_in.format(i,j,len(level_length),level)
            while len(level_length) > level:
                level_length.pop()
                output += self.interation_inner_in.format(i,j,len(level_length)+1,level,level_length)
                j += 1
            if level_length:
                count += level_length[-1]
                output += self.interation_one_in.format(level_length,count)
            else:
                output += self.interation_one_not_in.format(level_length)
            if '.' in line:
                ans = max(ans,count)
                output += self.interation_two_in.format(line,ans)
            else:
                level_length.append(count)
                output += self.interation_two_not_in.format(line,level_length)
            i += 1
        if not line_list:
            output += self.not_enter_loop.format(i,line_list)
        output += self.return_result.format(ans)
        answer = ans

        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(5)
    data = dg.rfft_IO(data)
    file = open("tasks/0388.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))