import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 392
        self.name = "Subsequence"
        self.description = '''Given two strings s and t, return true if s is a subsequence of t, or false otherwise.'''
        self.url = '''https://leetcode.com/problems/is-subsequence/description/'''
        self.rule = '''
def Subsequence(self,s: str, t: str) -> bool:
    if not s: return True
    i = 0
    t_list = list(t)
    while t_list:
        c = t_list.pop(0)
        if s[i] == c:
            i += 1
            if i == len(s):
                return True
    return False'''
        self.exception = '''
1. Jugde the excception
```
if not s: return True
```
s = '{}'
not s == True
enter
return True
So the answer is True.'''
        self.preparation = '''
1. Initialize
```
if not s: return True
```
s = '{}'
not s == False
not enter
```
i = 0
```
```
t_list = list(t)
```
t_list = {}

2. Main Loop'''
        self.one_iteration_2_1_jugde_in = '''
2.{} one iteration
```
while t_list:
```
t_list = {}
enter
```
c = t_list.pop(0)
```
c = '{}'
```
if s[i] == c:
```
c = '{}'
s[i] = '{}'
s[i] == c
enter
```
i += 1
```
i = {}'''
        self.one_iteration_2_1_jugde_not_in = '''
2.{} one iteration
```
while t_list:
```
t_list = {}
enter
```
c = t_list.pop(0)
```
c = '{}'
```
if s[i] == c:
```
c = '{}'
s[i] = '{}'
s[i] != c
not enter'''
        self.not_enter_loop = '''
2.{} one iteration
```
while t_list:
```
t_list = {}
not enter'''
        self.one_iteration_3_1_jugde_return_True = '''
3. Return Result
```
if i == len(s):
```
i = {}
len(s) = {}
i == len(s)
enter
```
return True
```
So the answer is True.'''
        self.one_iteration_3_1_jugde_not_return = '''
```
if i == len(s):
```
i = {}
len(s) = {}
i != len(s)
not enter'''
        self.one_iteration_3_1_jugde_not_return_False = '''
3. Return Result
```
return False
```
So the answer is False.'''


    def gen_data_from_len(self,length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s","t"
        '''
        import string
        length_ = np.random.randint(1,5)
        Alphabet = string.ascii_letters + string.digits
        s = ''.join(random.choices(Alphabet, k=length_))
        t = ''.join(random.choices(Alphabet, k=length))
        question = f"Given two strings s = '{s}' and t = '{t}' . If s is a subsequence of t?"

        return {"question": question,
                "s": s,
                "t": t}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        s = data['s']
        t = data['t']
        t_list = list(t)
        answer = False
        if s == '':
            output = self.exception.format(s,s)
            answer = True
            return {"input": input,
                "output": output,
                "answer": answer}
        output = self.preparation.format(s,s,t_list)
        i = 0
        j = 1
        while t_list:
            t_list_copy = deepcopy(t_list)
            c = t_list.pop(0)
            if s[i] == c:
                output += self.one_iteration_2_1_jugde_in.format(j,t_list_copy,c,c,s[i],i+1)
                i += 1
                if i == len(s):
                    output += self.one_iteration_3_1_jugde_return_True.format(i,len(s))
                    answer = True
                    break
                output += self.one_iteration_3_1_jugde_not_return.format(i,len(s))
            output += self.one_iteration_2_1_jugde_not_in.format(j,t_list_copy,c,c,s[i])
            j += 1
        if not t_list:
            output += self.not_enter_loop.format(j,t_list)
        if i+1<=len(s):
            output += self.one_iteration_3_1_jugde_not_return_False
            answer = False
        return {"input": input,
                "output": output,
                "answer": answer}
    
if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(5)
    data = dg.rfft_IO(data)
    file = open("tasks/0392.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))