import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 434
        self.name = "countSegments"
        self.description = '''Given a string s, What's the number of segments in the string?'''
        self.url = '''https://leetcode.com/problems/number-of-segments-in-a-string/description/'''
        self.rule = '''
def countSegments(self, s: str) -> int:
    sum = 0
    if s == '':
        return 0
    s_list = s.split()
    while s_list:
        s_list.pop()
        sum += 1
    return sum'''
        self.initialize_and_judge_yes = '''
1. initialize
```
sum = 0
```
```
if s == '':
```
s == ''
enter
```
return 0
```

So the answer is 0'''
        self.initialize_and_judge_no = '''
1. initialize
```
sum = 0
```
```
if s == '':
```
s == '{}'
s != ''
not enter
```
s_list = s.split()
```
s_list = {}

2. Main loop'''
        self.one_iteration_1 = '''
2.{} one iteration
```
while s_list:
```
s_list = {}
enter
```
s_list.pop()
```
s_list = {}
```
sum += 1
```
sum = {}'''
        self.not_enter_loop = '''
2.{} one iteration
```
while s_list:
```
s_list = {}
not enter'''
        self.return_result = '''
3. return result
```
return sum
```
So the answer is {}.'''


            

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","s"
        '''
        import string
        s = ''
        for i in range(1, length):
            s += ' ' + ''.join(random.choices(string.ascii_lowercase + string.ascii_uppercase + string.digits, k = random.choice(range(1, 7))))
        question = f'''s = "{s}". What's the number of segments in the string?'''
        return {"question": question,
                "s": s}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data['question']
        input = instruction + rule + "\n\nQ: " + qusetion
        s = data['s']
        s_list = s.split()
        if s == '':
            output = self.initialize_and_judge_yes
        else:
            output = self.initialize_and_judge_no.format(s,s_list)
        sum = 0
        i = 1
        while s_list:
            s_list_copy = deepcopy(s_list)
            s_list.pop()
            sum += 1
            output += self.one_iteration_1.format(i,s_list_copy,s_list,sum)
            i += 1
        if not s_list:
            output += self.not_enter_loop.format(i,s_list)
        output += self.return_result.format(sum)
        answer = sum
        return {"input": input,
                "output": output,
                "answer": answer}
    
if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(5)
    data = dg.rfft_IO(data)
    file = open("tasks/0434.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))