import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 448
        self.name = "disappeared_numbers"
        self.description = '''Given an array nums of n integers where nums is a permutation of the numbers in the range [1, n], return an array of all the integers in the range [1, n] that do not appear in nums.'''
        self.url = '''https://leetcode.com/problems/find-all-numbers-disappeared-in-an-array/description/'''
        self.rule = '''
def disappeared_numbers(nums):
    n = len(nums)
    list = [True]*n
    result = []
    i = 0
    while nums:
        num = nums.pop()
        if list[num-1]:
            list[num-1] = False
    while i < n:
        if list[i]:
            result.append(i+1)
        i += 1
    return result'''
        self.initialize = '''
1. Initialize:
```
n = len(nums)
```
n = {}
```
list = [True]*n
```
list = {}
```
result = []
```
```
i = 0
```

2. Main loop one:'''
        self.one_iteration_1_in = '''
2.{} one iteration:
```
while nums:
```
nums = {}
enter
```
num = nums.pop()
```
num = {}
```
if list[num-1]:
```
list[{}] == True
enter
```
list[num-1] = False
```
list[{}] = False'''
        self.one_iteration_1_not_in = '''
2.{} one iteration:
```
while nums:
```
nums = {}
enter
```
num = nums.pop()
```
num = {}
```
if list[num-1]:
```
list[{}] = False
not enter'''
        self.not_enter_loop1 = '''
2.{} one iteration:
```
while nums:
```
nums = {}
not enter'''
        self.one_iteration_2 = '''

3. Main loop two:'''
        self.one_iteration_2_in = '''
3.{} one iteration:
```
while i < n:
```
i = {}
n = {}
i < n
enter
```
if list[i]:
```
list[{}] = True
enter
```
result.append(i+1)
```
result = {}
```
i += 1
```
i = {}'''
        self.one_iteration_2_not_in = '''
3.{} one iteration:
```
while i < n:
```
i = {}
n = {}
i < n
enter
```
if list[i]:
```
list[{}] = False
noe enter
```
i += 1
```
i = {}'''
        self.not_enter_loop2 = '''
3.{} one iteration:
```
while i < n:
```
i = {}
n = {}
i >= n
not enter'''
        self.return_result = '''

4. return result:
```
return result
```
So the answer is {}.'''

           

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","nums"
        '''
        nums = []
        for i in range(length):
            nums.append(random.choice(range(1,length+1)))
        question = f'''question: nums = {nums}, and nums[i] is in the range [1, n]. What's the array of all the integers in the range [1, n] that do not appear in nums?'''

        return {"question": question,
                "nums": nums}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        nums = data['nums']
        n = len(nums)
        list = [True]*n
        result = []
        i = 0
        j = 1
        output = self.initialize.format(n,list)
        while nums:
            nums_copy = deepcopy(nums)
            num = nums.pop()
            if list[num-1]:
                list[num-1] = False
                output += self.one_iteration_1_in.format(j,nums_copy,num,num-1,num-1)
            else:
                output += self.one_iteration_1_not_in.format(j,nums_copy,num,num-1)
            j += 1
        if not nums:
            output += self.not_enter_loop1.format(j,nums)
        output += self.one_iteration_2
        while i < n:
            if list[i]:
                result.append(i+1)
                output += self.one_iteration_2_in.format(i+1,i,n,i,result,i+1)
            else:
                output += self.one_iteration_2_not_in.format(i+1,i,n,i,i+1)
            i += 1
        if i >= n:
            output += self.not_enter_loop2.format(i,i,n)
        output += self.return_result.format(result)
        answer = result
        return {"input": input,
                "output": output,
                "answer": answer}

if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/0448.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))