
import numpy as np
import random
from prompt import Prompt
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 541  
        self.name =  'string_kreverse'  
        self.description = "reverse every k characters in a string"  
        self.url = 'https://leetcode.com/problems/reverse-string-ii/description/'
         
        self.rule ='''
def string_kreverse(s, k):
# Initialize variables
ans = ''
n = 2*k
# Judge
if len(s)<k:
    ans += s[::-1]
else:
    # Main loop
    while len(s) > k:
        t = s[0:n]
        s = s[n:]
        x = t[0:k]
        t = t[k:]
        ans += x[::-1] + t
    # Complete loop
    if len(s) <= k:
        ans += s[::-1]
# Return
return ans'''
        self.initialize = '''
1. Initialize variables
s = {}
k = {}
```
ans = ''
n = 2*k
```
n = 2*k = 2*{} = {}
2. Judge'''
        self.judge_1 = '''
```
if len(s)<k:
```
len(s) = len({}) = {} < k = {}
enter
```
ans += s[::-1]
```
ans += s[::-1] = ans+'{}'[::-1] = '{}'+'{}' = '{}' '''
        self.judge_2 = '''
```
if len(s)<k:
```
len(s) = len('{}') = {} >= k = {}
do not enter
```
else:'''
        self.one_iteration_not_enter = '''
3. Main loop
```
while len(s) > k:
```
len(s) = len('{}') = {} <= k = {}
do not enter'''
        self.one_iteration_1 = '''
3. Main loop
```
while len(s) > k:
```
len(s) = len('{}') = {} > k = {}
enter
```
t = s[0:n]
s = s[n:]
x = t[0:k]
t = t[k:]
```
s = '{}'
t = s[0:n] = s[0:{}] = '{}'
s = s[n:] = s[{}:] = '{}'
x = t[0:k] = t[0:{}] = '{}'
t = t[k:] = t[{}:] = '{}' '''

        self.one_iteration_2 = '''
```
ans += x[::-1] + t
```
ans += x[::-1] + t = ans+'{}'[::-1]+'{}' = '{}'+'{}'+'{}' = '{}' '''
        self.complete_loop = '''
4. Complete loop
```
while len(s) > k:
```
len(s) = len('{}') = {} <= k = {}
do not enter'''
        self.judge_2_1= '''
```
if len(s) <= k:
```
len(s) = len('{}') = {} <= k = {}
enter
```
ans += s[::-1]
```
ans += s[::-1] = ans+'{}'[::-1] = '{}'+'{}' = '{}' '''
        self.judge_2_2 = '''
```
if len(s) <= k:
```
len(s) = len('{}') = {} > k = {}
do not enter'''
        self.return_result = '''
5. Return Result
```
return ans
```
ans = '{}'
So the answer is '{}' .'''

    def gen_data_from_len(self, length: int) -> dict:
        s = "".join(random.sample([chr(i) for i in range(ord('a'), ord('z')+1)], k=length))
        s_bk = s
        k = random.randint(1, length)
        question = f"A string '{s}' and an integer {k} , reverse the first {k} characters for every {2*k} characters counting from the start of the string. "
        ans = ''
        n = 2*k
        if len(s)<k:
            ans += s[::-1]
        else:
            while len(s) > k:
                t = s[0:n]
                s = s[n:]
                x = t[0:k]
                t = t[k:]
                ans += x[::-1] + t
            if len(s) <= k:
                ans += s[::-1]
        gt = ans
        return {"question": question,
                "gt": gt,
                "s": s_bk,
                "k": k}
        '''
        return datapoint of given length
        
        return {...}
        '''
            
        
    def rfft_IO(self, data: dict) -> dict:
        instruction = "Follow the given rule to solve the question.\nrule:"
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        s = data["s"]
        k = data["k"]
        output = self.initialize.format(s, k, k, 2*k)
        ans = ''
        n = 2*k

        if len(s)<k:
            output += self.judge_1.format(s, len(s), k, s, ans, s[::-1], ans + s[::-1])
            ans += s[::-1]
        else:
            output += self.judge_2.format(s, len(s), k, s)
            if len(s) <= k:
                output += self.one_iteration_not_enter.format(s, len(s), k)
            while len(s) > k:
                output += self.one_iteration_1.format(s, len(s), k, s, n, s[0:n], n, s[n:], k, s[0:n][0:k], k, s[0:n][k:])
                t = s[0:n]
                s = s[n:]
                x = t[0:k]
                t = t[k:]
                output += self.one_iteration_2.format(x, t, ans, x[::-1], t, ans + x[::-1] + t)
                ans += x[::-1] + t
                if len(s) <= k:
                    output += self.complete_loop.format(s, len(s), k)
            if len(s) <= k:
                output += self.judge_2_1.format(s, len(s), k, s, ans, s[::-1], ans + s[::-1])
                ans += s[::-1]
            else:
                output += self.judge_2_2.format(s, len(s), k)
        output += self.return_result.format(ans, ans)
        return {"input": input,
                "output": output,
                "answer": ans}
    

Generator = Dataset_Generator()
length = 10
data = Generator.gen_data_from_len(length)
print(data)

sample = Generator.rfft_IO(data)
print(sample["input"], sample["output"])