
import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 283  
        self.name =  'student_attendence'  
        self.description = ""  
        self.url = 'https://leetcode.com/problems/student-attendance-record-i/description/'
         
        self.rule = '''
def student_attendence(s: str) -> bool:
    # Initialize variables
    absent = 0
    late = 0
    # Main loop
    while s:
        c = s[0]
        s = s[1:]
        if c == "L":
            late += 1
            if late >= 3:
                return False
        else:
            late = 0
            if c == "A":
                absent += 1
                if absent > 1:
                    return False
    return True
'''
        self.initialize = '''
1. Initialize variables
s = '{}'
```
a = 0
l = 0
isEligible = True
s = list(s)
```
s = list(s) = list('{}') = {}
2. Main loop'''
        self.one_iteration_2_1 = '''
2.1 one iteration
```
while s:
```
s = {} != None
enter
```
i = s.pop(0)
```
i = s.pop(0) = s[0] = '{}'
s = s[1:] = {}
```'''
        self.one_iteration_2_1_1_enter_1 = '''
```
if i == "L":
```
i = '{}' = 'L'
enter
```
l += 1
```
l += 1 = l+1 = {}+1 = {}
```
if l >= 3:
```
l = {} >= 3
enter
```
isEligible = False
```
isEligible = False
break
```
jump out of the while loop'''
        self.one_iteration_2_1_1_enter_2 = '''
```
if i == "L":
```
i = '{}' == 'L'
enter
```
l += 1
```
l += 1 = l+1 = {}+1 = {}
```
if l >= 3:
```
l = {} < 3
do not enter
```'''
        self.one_iteration_2_1_2_a_enter = '''
```
if i == "L":
```
i = '{}' != 'L'
do not enter
```
else:
l = 0
```
l = 0
```
if i == "A":
```
i = '{}' = 'A'
enter
```
a += 1
```
a = a+1 = {}+1 = {}
```
if a > 1:
```
a = {} > 1
enter
```
isEligible = False
break
```
jump out of the while loop'''
        self.one_iteration_2_1_2_a_not_enter = '''
```
if i == "L":
```
i = '{}' != 'L'
do not enter
```
else:
l = 0
```
l = 0
```
if i == "A":
```
i = '{}' == 'A'
enter
```
a += 1
```
a = a+1 = {}+1 = {}
```
if a > 1:
```
a = {} <= 1
do not enter
```'''
        self.one_iteration_2_1_2_not_a = '''
```
if i == "L":
```
i = '{}' != 'L'
do not enter
```
else:
l = 0
```
l = 0
```
if i == "A":
```
i = '{}' != 'A'
do not enter
```'''
        self.complete_loop = '''
2.2 complete loop
```
while s:
```
s = {} == None
do not enter'''
        self.return_result = '''
3. Return Result
```
return isEligible
```
isEligible = {}
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        s = random.choices(['A', 'L', 'self'], k=length)
        string = ''.join(s)
        question = f"A string consists of 'A', 'L' and 'self' means the student is attending, late or absent respectively. The string is '{string}'. Answer whether the student was absent for strictly fewer than 2 days total and never late for 3 or more consecutive days?"
        a = 0
        l = 0
        isEligible = True
        while s:
            i = s.pop(0)
            if i == "L":
                l += 1
                if l >= 3:
                    isEligible = False
                    break
            else:
                l = 0
                if i == "A":
                    a += 1
                    if a > 1:
                        isEligible = False
                        break
        return {"question": question,
                "gt": 'Yes' if isEligible else 'No',
                "s": string}
        
        '''
        return datapoint of given length
        
        return {...}
        '''
            
        
    def rfft_IO(self, data: dict) -> dict:
        instruction = "Follow the given rule to solve the question.\nrule:"
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        s = data["s"]
        a = 0
        l = 0
        isEligible = True
        output = self.initialize.format(s, s, list(s))
        s = list(s)
        while s:
            output += self.one_iteration_2_1.format(s, s[0], s[1:])
            i = s.pop(0)
            if i == "L":
                if l >= 2:
                    output += self.one_iteration_2_1_1_enter_1.format(i, l, l+1, l+1)
                    l+=1
                    isEligible = False
                    break
                else:
                    output += self.one_iteration_2_1_1_enter_2.format(i, l, l+1, l+1)
                    l+=1
            else:
                l = 0
                if i == "A":
                    if a > 0:
                        output += self.one_iteration_2_1_2_a_enter.format(i, i, a, a+1, a+1)
                        isEligible = False
                        a += 1
                        break
                    else:
                        output += self.one_iteration_2_1_2_a_not_enter.format(i, i, a, a+1, a+1)
                        a += 1
                else:
                    output += self.one_iteration_2_1_2_not_a.format(i, i)
            if not s:
                output += self.complete_loop.format(s)
        answer = "Yes" if isEligible else "No"
        output += self.return_result.format(isEligible, answer)
        return {"input": input,
                "output": output,
                "answer": answer}

Generator = Dataset_Generator()
length = 10
data = Generator.gen_data_from_len(length)
print(data)

sample = Generator.rfft_IO(data)
print(sample["input"], sample["output"])