import random

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 605  
        self.name = 'Can Place Flowers'  
        self.url = 'https://leetcode.com/problems/can-place-flowers/description/'
         
        self.rule = '''
def can_place_flowers(array, n):
    # Initialize Pointers
    count = 0
    prev = 0
    # Main Loop
    while array:
        cur = array.pop(0)
        if cur == 1:
            if prev == 1:
                count -= 1
            prev = 1
        else:
            if prev == 1:
                prev = 0 
            else:
                count += 1
                prev = 1
    # Return Result
    if count >= n:
        return True
    else:
        return False'''
        self.initialize = '''
array = {}
n = {}
1. Initialize Pointers
count = 0
prev = 0
2. Main Loop'''
        self.one_iteration_2_1_1_1 = '''
2.1 one iteration
```
while array:
```
array = {}
enter
```
cur = array.pop(0)
```
cur = array.pop(0) = 1
array = {}
```
if cur == 1:
```
cur == 1
enter
```
if prev == 1:
```
prev == 1
enter
```
count -= 1
```
count = {} - 1 = {}
```
prev = 1
```
prev = 1'''
        self.one_iteration_2_1_1_0 = '''
2.1 one iteration
```
while array:
```
array = {}
enter
```
cur = array.pop(0)
```
cur = array.pop(0) = 1
array = {}
```
if cur == 1:
```
cur == 1
enter
```
if prev == 1:
```
prev == 0
do not enter
```
prev = 1
```
prev = 1'''
        self.one_iteration_2_1_0_1 = '''
2.1 one iteration
```
while array:
```
array = {}
enter
```
cur = array.pop(0)
```
cur = array.pop(0) = 0
array = {}
```
if cur == 1:
```
cur == 0
do not enter
```
else:
    if prev == 1:
```
prev == 1
enter
```
prev = 0
```
prev = 0'''
        self.one_iteration_2_1_0_0 = '''
2.1 one iteration
```
while array:
```
array = {}
enter
```
cur = array.pop(0)
```
cur = array.pop(0) = 0
array = {}
```
if cur == 1:
```
cur == 0
do not enter
```
else:
    if prev == 1:
```
prev == 0
do not enter
```
else:
    count += 1
```
count = {} + 1 = {}
```
prev = 1
```
prev = 1'''
        self.return_result_true = '''
2.1 one iteration
```
while array:
```
array = []
do not enter
3. Return Result
```
if count >= n:
```
count = {}
n = {}
count >= n
enter
```
return True
```
return True
So the answer is {}.'''
        self.return_result_false = '''
2.1 one iteration
```
while array:
```
array = []
do not enter
3. Return Result
```
if count >= n:
```
count = {}
n = {}
count < n
do not enter
```
return False
```
return False
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length
        
        return {...}
        '''
        # example question: Can 2 1's be placed in the array [1,0,0,0,1] such that no two 1's are adjacent?
        # example answer: No
        def generate_flowerbed(length: int) -> list[int]:
            # Generate a random flowerbed with length `length`
            flowerbed = [0] * length
            for i in range(1, length):
                if flowerbed[i - 1] != 1:
                    flowerbed[i] = random.choice([0, 0, 1])
            return flowerbed

        def place_flowers(array: list[int], n: int) -> bool:
            # Initialize pointers
            count = 0
            prev = 0
            # Main loop
            for cur in array:
                if cur == 1:
                    if prev == 1:
                        count -= 1
                    prev = 1
                else:
                    if prev == 1:
                        prev = 0
                    else:
                        count += 1
                        prev = 1
            return count >= n
        arr = generate_flowerbed(length)
        n = random.choice([random.randint(0, length), random.randint(0, length // 3)])
        question = f"Can {n} 1's be placed in the array {arr} such that no two 1's are adjacent?"
        gt = "Yes" if place_flowers(arr, n) else "No"
        return {"question": question,
                "gt": gt,
                "array": arr,
                "integer": n}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        array = data["array"]
        integer = data["integer"]
        count = 0
        prev = 0
        output = self.initialize.format(array, integer)
        for idx in range(len(array)):
            cur = array[idx]
            if cur == 1:
                if prev == 1:
                    count -= 1
                    output += self.one_iteration_2_1_1_1.format(array[idx:], array[idx + 1:], count + 1, count)
                else:
                    output += self.one_iteration_2_1_1_0.format(array[idx:], array[idx + 1:])
                prev = 1
            else:
                if prev == 1:
                    prev = 0
                    output += self.one_iteration_2_1_0_1.format(array[idx:], array[idx + 1:])
                else:
                    count += 1
                    prev = 1
                    output += self.one_iteration_2_1_0_0.format(array[idx:], array[idx + 1:], count - 1, count)
        answer = "Yes" if count >= integer else "No"
        if count >= integer:
            output += self.return_result_true.format(count, integer, "Yes")
        else:
            output += self.return_result_false.format(count, integer, "No")
        return {"input": input,
                "output": output,
                "answer": answer}
        
