import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 674  
        self.name = 'Longest Continuous Increasing Subsequence'  
        self.url = 'https://leetcode.com/problems/longest-continuous-increasing-subsequence/description/'
         
        self.rule = '''
def longest_continuous_increasing_subsequence(nums):
    # Initialize Variables
    cur_len = 1
    max_len = 1
    pre_num = nums.pop(0)
    # Main Loop
    while nums:
        cur_num = nums.pop(0)
        if cur_num > pre_num:
            cur_len += 1
            pre_num = cur_num
        else:
            cur_len = 1
            pre_num = cur_num
        max_len = max(max_len, cur_len)
    # Return Result
    return max_len'''
        self.initialize = '''
nums = {}
1. Initialize Variables
cur_len = 1
max_len = 1
pre_num = nums.pop(0) = {}
2. Main Loop'''
        self.one_iteration_1 = '''
2.1 one iteration
```
while nums:
```
nums = {}
enter
```
cur_num = nums.pop(0)
```
cur_num = nums.pop(0) = {}
nums = {}
```
if cur_num > pre_num:
```
cur_num = {}
pre_num = {}
cur_num > pre_num
enter
```
cur_len += 1
```
cur_len = {} + 1 = {}
```
pre_num = cur_num
```
pre_num = cur_num = {}'''
        self.one_iteration_2 = '''
2.1 one iteration
```
while nums:
```
nums = {}
enter
```
cur_num = nums.pop(0)
```
cur_num = nums.pop(0) = {}
nums = {}
```
if cur_num > pre_num:
```
cur_num = {}
pre_num = {}
cur_num <= pre_num
do not enter
```
else:
    cur_len = 1
```
cur_len = 1
```
pre_num = cur_num
```
pre_num = cur_num = {}'''
        self.find_max = '''
```
max_len = max(max_len, cur_len)
```
max_len = max({}, {}) = {}'''
        self.return_result = '''
2.1 one iteration
```
while nums:
```
nums = []
do not enter
3. Return Result
```
return max_len
```
return max_len
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length
        
        return {...}
        '''
        # example question: Given the array [10, 9, 2, 5, 3, 7, 101, 18], find the length of its longest continuous increasing subsequence. The subsequence must be strictly increasing.
        # example answer: 3
        def generate_longest_increasing_subsequence(length: int) -> list[int]:
            # Generate a random longest increasing subsequence with length `length`
            nums = [random.randint(1, length * 3) for _ in range(length)]
            inc_len = random.randint(1, length - 1)
            st = random.randint(0, length - inc_len)
            nums[st:st + inc_len] = sorted(nums[st:st + inc_len])
            return nums

        def find_longest_continuous_increasing_subsequence(arr: list[int]) -> int:
            nums = deepcopy(arr)
            cur_len = 1
            max_len = 1
            pre_num = nums.pop(0)
            while nums:
                cur_num = nums.pop(0)
                if cur_num > pre_num:
                    cur_len += 1
                    pre_num = cur_num
                else:
                    cur_len = 1
                    pre_num = cur_num
                max_len = max(max_len, cur_len)
            return max_len
        nums = generate_longest_increasing_subsequence(length)
        question = f"Given the array {nums}, find the length of its longest continuous increasing subsequence. The subsequence must be strictly increasing."
        gt = find_longest_continuous_increasing_subsequence(nums)
        return {"question": question,
                "gt": gt,
                "array": nums}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        nums = data["array"]
        cur_len = 1
        max_len = 1
        pre_num = nums.pop(0)
        output = self.initialize.format([pre_num] + nums, pre_num)
        while nums:
            cur_num = nums.pop(0)
            if cur_num > pre_num:
                output += self.one_iteration_1.format([cur_num] + nums, cur_num, nums, cur_num, pre_num, cur_len,
                                                   cur_len + 1, cur_num)
                cur_len += 1
                pre_num = cur_num
            else:
                output += self.one_iteration_2.format([cur_num] + nums, cur_num, nums, cur_num, pre_num, cur_num)
                cur_len = 1
                pre_num = cur_num
            output += self.find_max.format(max_len, cur_len, max(max_len, cur_len))
            max_len = max(max_len, cur_len)
        output += self.return_result.format(max_len)
        answer = max_len
        return {"input": input,
                "output": output,
                "answer": answer}
