import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 682  
        self.name = 'Baseball Game'    
        self.url = 'https://leetcode.com/problems/baseball-game/description/'
         
        self.rule = '''
def baseball_game(ops):
    # Initialize Stack and Score
    stack = []
    s = 0
    # Main Loop
    while ops:
        op = ops.pop(0)
        if op == 'C':
            s -= stack.pop()
        elif op == 'D':
            stack.append(2*stack[-1])
            s += stack[-1]
        elif op == '+':
            stack.append(stack[-1] + stack[-2])
            s += stack[-1]
        else:
            stack.append(int(op))
            s += stack[-1]
    # Return Result
    return s'''
        self.initialize = '''
ops = {}
1. Initialize Stack and Score
stack = []
s = 0
2. Main Loop'''
        self.one_iteration_C = '''
2.1 one iteration
```
while ops:
```
ops = {}
enter
```
op = ops.pop(0)
```
op = ops.pop(0) = 'C'
ops = {}
```
if op == 'C':
```
op == 'C'
enter
```
s -= stack.pop()
```
s = {} - {} = {}'''
        self.one_iteration_D = '''
2.1 one iteration
```
while ops:
```
ops = {}
enter
```
op = ops.pop(0)
```
op = ops.pop(0) = 'D'
ops = {}
```
if op == 'C':
```
op = 'D'
do not enter
```
elif op == 'D':
```
op == 'D'
enter
```
stack.append(2*stack[-1])
```
stack.append(2*{})
stack = {}
```
s += stack[-1]
```
s = {} + {} = {}'''
        self.one_iteration_plus = '''
2.1 one iteration
```
while ops:
```
ops = {}
enter
```
op = ops.pop(0)
```
op = ops.pop(0) = '+'
ops = {}
```
if op == 'C':
```
op = '+'
do not enter
```
elif op == 'D':
```
op = '+'
do not enter
```
elif op == '+':
```
op == '+'
enter
```
stack.append(stack[-1] + stack[-2])
```
stack.append({} + {})
stack = {}
```
s += stack[-1]
```
s = {} + {} = {}'''
        self.one_iteration_int = '''
2.1 one iteration
```
while ops:
```
ops = {}
enter
```
op = ops.pop(0)
```
op = ops.pop(0) = '{}'
ops = {}
```
if op == 'C':
```
op = '{}'
do not enter
```
elif op == 'D':
```
op = '{}'
do not enter
```
elif op == '+':
```
op = '{}'
do not enter
```
else:
    stack.append(int(op))
```
stack.append(int('{}'))
stack = {}
```
s += stack[-1]
```
s = {} + {} = {}'''
        self.return_result = '''
2.1 one iteration
```
while ops:
```
ops = []
do not enter
3. Return Result
```
return s
```
return s
So the answer is {}.'''

    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length
        
        return {...}
        '''
        # example question: Starting with an empty record, after applying the operations in the list ["5","2","C","D","+"] where an integer x means "record a new score of x", "+" means "record a new score that is the sum of the previous two scores", "D" means "record a new score that is the double of the previous score" and "C" means "invalidate the previous score, removing it from the record". What is the sum of all the scores on the record after applying all the operations?
        # example answer: 30
        def generate_baseball_game(length: int) -> list[int]:
            # Generate a random baseball game operations with length `length`
            ops = []
            cur_len = 0
            for i in range(length):
                choice = [str(random.randint(1, 10)), str(random.randint(1, 10))]
                if cur_len >= 1:
                    choice += ["C", "D"]
                if cur_len >= 2:
                    choice += ["+", "+"]
                op = random.choice(choice)
                if op == "C":
                    cur_len -= 1
                else:
                    cur_len += 1
                ops.append(op)
            return ops

        def solve_baseball_game(ops: list[str]) -> int:
            stack = []
            s = 0
            for op in ops:
                if op == "C":
                    s -= stack.pop()
                elif op == 'D':
                    stack.append(2 * stack[-1])
                    s += stack[-1]
                elif op == "+":
                    stack.append(stack[-1] + stack[-2])
                    s += stack[-1]
                else:
                    stack.append(int(op))
                    s += stack[-1]
            return s
        ops = generate_baseball_game(length)
        question = f"Starting with an empty record, after applying the operations in the list {ops} where an integer x means \"record a new score of x\", \"+\" means \"record a new score that is the sum of the previous two scores\", \"D\" means \"record a new score that is the double of the previous score\" and \"C\" means \"invalidate the previous score, removing it from the record\". What is the sum of all the scores on the record after applying all the operations?"
        gt = solve_baseball_game(ops)
        return {"question": question,
                "gt": gt,
                "ops": ops}
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        
        return {"input": rfft_input,
                "output": rfft_output,
                "answer": ground_truth_answer}
        '''
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        input = instruction + rule + "\n\nQ: " + data["question"]
        # rfft output
        ops = data["ops"]
        stack = []
        s = 0
        output = self.initialize.format(ops)
        while ops:
            op = ops.pop(0)
            if op == "C":
                output += self.one_iteration_C.format([op] + ops, ops, s, stack[-1], s - stack[-1])
                s -= stack.pop()
            elif op == 'D':
                stack.append(2 * stack[-1])
                output += self.one_iteration_D.format([op] + ops, ops, stack[-2], stack, s, stack[-1], s + stack[-1])
                s += stack[-1]
            elif op == "+":
                stack.append(stack[-1] + stack[-2])
                output += self.one_iteration_plus.format([op] + ops, ops, stack[-2], stack[-3], stack, s, stack[-1],
                                                      s + stack[-1])
                s += stack[-1]
            else:
                stack.append(int(op))
                output += self.one_iteration_int.format([op] + ops, op, ops, op, op, op, op, stack, s, stack[-1],
                                                     s + stack[-1])
                s += stack[-1]
        output += self.return_result.format(s)
        answer = s
        return {"input": input,
                "output": output,
                "answer": answer}
