import numpy as np
import random
from copy import deepcopy

class Dataset_Generator:
    def __init__(self) -> None:
        self.id = 824
        self.name = "Goat_Latin"
        self.description = '''If a word begins with a vowel, append "ma" to the end of the word.If a word begins with a consonant (i.e., not a vowel), remove the first letter and append it to the end, then add "ma".Add one letter 'a' to the end of each word per its word index in the sentence, starting with 1.What's the final sentence representing the conversion from sentence to Goat Latin?'''
        self.url = '''https://leetcode.com/problems/goat-latin/description/'''
        self.rule = '''
def Goat_Latin(sentence: str) -> str:
    list = sentence.split()
    list_result = []
    while list:
        word = list.pop(0)
        if word[0] in 'aeiouAEIOU':
            word_ma = word + 'ma'
        else:
            word_ma = word[1:] + word[0] + 'ma'
        word_ma_na = word_ma + 'a' * (len(list_result) + 1)
        list_result.append(word_ma_na)
    return ' '.join(list_result)'''
        self.initialize = '''
1. Initialize
```
list = sentence.split()
```
list = '{}'
```
list_result = []
```
2. Main loop'''
        self.the_2_1_iteration_in = '''
2.{} one iteration
```
while list:
```
list = {}
enter
```
word = list.pop(0)
```
word = '{}'
```
if word[0] in 'aeiouAEIOU':
```
word[0] = '{}'
word[0] in 'aeiouAEIOU'
enter
```
word_ma = word + 'ma'
```
word_ma = '{}'
```
word_ma_na = word_ma + 'a' * (len(list_result) + 1)
```
len(list_result) = {}
word_ma_na = '{}'
```
list_result.append(word_ma_na)
```
list_result = {}'''

        self.the_2_1_iteration_not_in = '''
2.{} one iteration
```
while list:
```
list = {}
enter
```
word = list.pop(0)
```
word = '{}'
```
if word[0] in 'aeiouAEIOU':
```
word[0] = '{}'
word[0] not in 'aeiouAEIOU'
not enter
```
else:
```
word_ma = word[1:] + word[0] + 'ma'
```
word_ma = '{}'
```
word_ma_na = word_ma + 'a' * (len(list_result) + 1)
```
len(list_result) = {}
word_ma_na = '{}'
```
list_result.append(word_ma_na)
```
list_result = {}'''
        self.not_enter_loop = '''
2.{} one iteration
```
while list:
```
list = {}
not enter'''
        self.return_result = '''
3. Return result
```
return ' '.join(list)
```
' '.join(list) = '{}'

So the answer is '{}'.'''


    def gen_data_from_len(self, length: int) -> dict:
        '''
        return datapoint of given length,
        datapoint is a dict of keys including "question","sentence"
        '''
        import string
        Alphabet = string.ascii_letters
        sentence = ''
        length_ = random.randint(1,7)
        for i in range(length):
            sentence += ' ' + ''.join(random.choices(Alphabet, k=length_))
        question = f'''sentence = "{sentence}" If If a word begins with a vowel ('a', 'e', 'i', 'o', or 'u'), append "ma" to the end of the word.If a word begins with a consonant (i.e., not a vowel), remove the first letter and append it to the end, then add "ma".Add one letter 'a' to the end of each word per its word index in the sentence, starting with 1.What's the final sentence representing the conversion from sentence to Goat Latin?'''

        return {"question": question,
                "sentence": sentence}
            
        
    def rfft_IO(self, data: dict) -> dict:
        '''
        data: a datapoint from gen_data_from_len
        return rfft input-output of given data
        '''
        
        instruction = "Follow the given rule to solve the question.\nrule:"
        rule = self.rule
        qusetion = data["question"]
        input = instruction + rule + "\n\nQ: " + qusetion
        sentence = data["sentence"]
        list = sentence.split()
        list_result = []
        output = self.initialize.format(list)
        i = 1
        while list:
            list_copy = deepcopy(list)
            word = list.pop(0)
            if word[0] in 'aeiouAEIOU':
                word_ma = word + 'ma'
                word_ma_na = word_ma + 'a' * (len(list_result) + 1)
                list_result.append(word_ma_na)
                output += self.the_2_1_iteration_in.format(i,list_copy,word,word[0],word_ma,len(list_result)-1,word_ma_na,list_result)
            else:
                word_ma = word[1:] + word[0] + 'ma'
                word_ma_na =  word_ma + 'a' * (len(list_result) + 1)
                list_result.append(word_ma_na)
                output += self.the_2_1_iteration_not_in.format(i,list_copy,word,word[0],word_ma,len(list_result)-1,word_ma_na,list_result)
            i += 1
        if not list:
            output += self.not_enter_loop.format(i,list)
        answer = ' '.join(list_result)
        output += self.return_result.format(answer,answer)
        return {"input": input,
                "output": output,
                "answer": answer}
    
if __name__ == "__main__":
    dg = Dataset_Generator()
    data = dg.gen_data_from_len(10)
    data = dg.rfft_IO(data)
    file = open("tasks/0824.json", "w")
    file.write(data['input'] + data['output'] + str(data['answer']))